/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeReservedInstancesResponse.Builder, DescribeReservedInstancesResponse> {
    private final List<ReservedInstances> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        this.reservedInstances = builder.reservedInstances;
    }

    /**
     * <p>
     * A list of Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Reserved Instances.
     */
    public List<ReservedInstances> reservedInstances() {
        return reservedInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservedInstances() == null) ? 0 : reservedInstances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse) obj;
        if (other.reservedInstances() == null ^ this.reservedInstances() == null) {
            return false;
        }
        if (other.reservedInstances() != null && !other.reservedInstances().equals(this.reservedInstances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (reservedInstances() != null) {
            sb.append("ReservedInstances: ").append(reservedInstances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * 
         * @param reservedInstances
         *        A list of Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(Collection<ReservedInstances> reservedInstances);

        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * 
         * @param reservedInstances
         *        A list of Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(ReservedInstances... reservedInstances);
    }

    private static final class BuilderImpl implements Builder {
        private List<ReservedInstances> reservedInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            setReservedInstances(model.reservedInstances);
        }

        public final Collection<ReservedInstances> getReservedInstances() {
            return reservedInstances;
        }

        @Override
        public final Builder reservedInstances(Collection<ReservedInstances> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstances... reservedInstances) {
            reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        public final void setReservedInstances(Collection<ReservedInstances> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copy(reservedInstances);
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }
    }
}
