/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeNetworkAcls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkAclsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeNetworkAclsResponse.Builder, DescribeNetworkAclsResponse> {
    private final List<NetworkAcl> networkAcls;

    private DescribeNetworkAclsResponse(BuilderImpl builder) {
        this.networkAcls = builder.networkAcls;
    }

    /**
     * <p>
     * Information about one or more network ACLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more network ACLs.
     */
    public List<NetworkAcl> networkAcls() {
        return networkAcls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkAcls() == null) ? 0 : networkAcls().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsResponse)) {
            return false;
        }
        DescribeNetworkAclsResponse other = (DescribeNetworkAclsResponse) obj;
        if (other.networkAcls() == null ^ this.networkAcls() == null) {
            return false;
        }
        if (other.networkAcls() != null && !other.networkAcls().equals(this.networkAcls())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (networkAcls() != null) {
            sb.append("NetworkAcls: ").append(networkAcls()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeNetworkAclsResponse> {
        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * 
         * @param networkAcls
         *        Information about one or more network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcls(Collection<NetworkAcl> networkAcls);

        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * 
         * @param networkAcls
         *        Information about one or more network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcls(NetworkAcl... networkAcls);
    }

    private static final class BuilderImpl implements Builder {
        private List<NetworkAcl> networkAcls;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsResponse model) {
            setNetworkAcls(model.networkAcls);
        }

        public final Collection<NetworkAcl> getNetworkAcls() {
            return networkAcls;
        }

        @Override
        public final Builder networkAcls(Collection<NetworkAcl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copy(networkAcls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(NetworkAcl... networkAcls) {
            networkAcls(Arrays.asList(networkAcls));
            return this;
        }

        public final void setNetworkAcls(Collection<NetworkAcl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copy(networkAcls);
        }

        @Override
        public DescribeNetworkAclsResponse build() {
            return new DescribeNetworkAclsResponse(this);
        }
    }
}
