/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeNatGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNatGatewaysResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeNatGatewaysResponse.Builder, DescribeNatGatewaysResponse> {
    private final List<NatGateway> natGateways;

    private final String nextToken;

    private DescribeNatGatewaysResponse(BuilderImpl builder) {
        this.natGateways = builder.natGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the NAT gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the NAT gateways.
     */
    public List<NatGateway> natGateways() {
        return natGateways;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((natGateways() == null) ? 0 : natGateways().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysResponse)) {
            return false;
        }
        DescribeNatGatewaysResponse other = (DescribeNatGatewaysResponse) obj;
        if (other.natGateways() == null ^ this.natGateways() == null) {
            return false;
        }
        if (other.natGateways() != null && !other.natGateways().equals(this.natGateways())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (natGateways() != null) {
            sb.append("NatGateways: ").append(natGateways()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeNatGatewaysResponse> {
        /**
         * <p>
         * Information about the NAT gateways.
         * </p>
         * 
         * @param natGateways
         *        Information about the NAT gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateways(Collection<NatGateway> natGateways);

        /**
         * <p>
         * Information about the NAT gateways.
         * </p>
         * 
         * @param natGateways
         *        Information about the NAT gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateways(NatGateway... natGateways);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<NatGateway> natGateways;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysResponse model) {
            setNatGateways(model.natGateways);
            setNextToken(model.nextToken);
        }

        public final Collection<NatGateway> getNatGateways() {
            return natGateways;
        }

        @Override
        public final Builder natGateways(Collection<NatGateway> natGateways) {
            this.natGateways = NatGatewayListCopier.copy(natGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(NatGateway... natGateways) {
            natGateways(Arrays.asList(natGateways));
            return this;
        }

        public final void setNatGateways(Collection<NatGateway> natGateways) {
            this.natGateways = NatGatewayListCopier.copy(natGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNatGatewaysResponse build() {
            return new DescribeNatGatewaysResponse(this);
        }
    }
}
