/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeMovingAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMovingAddressesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMovingAddressesResponse.Builder, DescribeMovingAddressesResponse> {
    private final List<MovingAddressStatus> movingAddressStatuses;

    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The status for each Elastic IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The status for each Elastic IP address.
     */
    public List<MovingAddressStatus> movingAddressStatuses() {
        return movingAddressStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((movingAddressStatuses() == null) ? 0 : movingAddressStatuses().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse) obj;
        if (other.movingAddressStatuses() == null ^ this.movingAddressStatuses() == null) {
            return false;
        }
        if (other.movingAddressStatuses() != null && !other.movingAddressStatuses().equals(this.movingAddressStatuses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (movingAddressStatuses() != null) {
            sb.append("MovingAddressStatuses: ").append(movingAddressStatuses()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * 
         * @param movingAddressStatuses
         *        The status for each Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses);

        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * 
         * @param movingAddressStatuses
         *        The status for each Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movingAddressStatuses(MovingAddressStatus... movingAddressStatuses);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            setMovingAddressStatuses(model.movingAddressStatuses);
            setNextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus> getMovingAddressStatuses() {
            return movingAddressStatuses;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus... movingAddressStatuses) {
            movingAddressStatuses(Arrays.asList(movingAddressStatuses));
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }
    }
}
