/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeImages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImagesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeImagesRequest.Builder, DescribeImagesRequest> {
    private final List<String> executableUsers;

    private final List<Filter> filters;

    private final List<String> imageIds;

    private final List<String> owners;

    private DescribeImagesRequest(BuilderImpl builder) {
        this.executableUsers = builder.executableUsers;
        this.filters = builder.filters;
        this.imageIds = builder.imageIds;
        this.owners = builder.owners;
    }

    /**
     * <p>
     * Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code> (the
     * sender of the request), or <code>all</code> (public AMIs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code>
     *         (the sender of the request), or <code>all</code> (public AMIs).
     */
    public List<String> executableUsers() {
        return executableUsers;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS
     * volume is deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
     * <code>/dev/sdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> |
     * <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>description</code> - The description of the image (provided during image creation).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-id</code> - The ID of the image.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>is-public</code> - A Boolean that indicates whether the image is public.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manifest-location</code> - The location of the image manifest.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of the AMI (provided during image creation).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> |
     * <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
     * user-configured AWS account alias, which is set from the IAM console.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the image owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code.type</code> - The type of the product code (<code>devpay</code> | <code>marketplace</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-name</code> - The name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     * <code>instance-store</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>
     * ).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-code</code> - The reason code for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-message</code> - The message for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the tag-value
     * filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any
     * resources assigned both the tag key Purpose (regardless of what the tag's value is), and the tag value X
     * (regardless of what the tag's key is). If you want to list only resources where Purpose is X, see the
     * <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the
     *         Amazon EBS volume is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
     *         <code>/dev/sdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> |
     *         <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the image (provided during image creation).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-id</code> - The ID of the image.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
     *         <code>ramdisk</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>is-public</code> - A Boolean that indicates whether the image is public.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manifest-location</code> - The location of the image manifest.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the AMI (provided during image creation).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> |
     *         <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
     *         user-configured AWS account alias, which is set from the IAM console.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the image owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code.type</code> - The type of the product code (<code>devpay</code> |
     *         <code>marketplace</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-name</code> - The name of the root device volume (for example, <code>/dev/sda1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     *         <code>instance-store</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
     *         <code>failed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-code</code> - The reason code for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-message</code> - The message for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         tag-value filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X",
     *         you get any resources assigned both the tag key Purpose (regardless of what the tag's value is), and the
     *         tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     *         see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more image IDs.
     * </p>
     * <p>
     * Default: Describes all images available to you.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more image IDs.</p>
     *         <p>
     *         Default: Describes all images available to you.
     */
    public List<String> imageIds() {
        return imageIds;
    }

    /**
     * <p>
     * Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
     * request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code> |
     * <code>microsoft</code>). Omitting this option returns all images for which you have launch permissions,
     * regardless of ownership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
     *         request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code> |
     *         <code>microsoft</code>). Omitting this option returns all images for which you have launch permissions,
     *         regardless of ownership.
     */
    public List<String> owners() {
        return owners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((executableUsers() == null) ? 0 : executableUsers().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((imageIds() == null) ? 0 : imageIds().hashCode());
        hashCode = 31 * hashCode + ((owners() == null) ? 0 : owners().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest) obj;
        if (other.executableUsers() == null ^ this.executableUsers() == null) {
            return false;
        }
        if (other.executableUsers() != null && !other.executableUsers().equals(this.executableUsers())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.imageIds() == null ^ this.imageIds() == null) {
            return false;
        }
        if (other.imageIds() != null && !other.imageIds().equals(this.imageIds())) {
            return false;
        }
        if (other.owners() == null ^ this.owners() == null) {
            return false;
        }
        if (other.owners() != null && !other.owners().equals(this.owners())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (executableUsers() != null) {
            sb.append("ExecutableUsers: ").append(executableUsers()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (imageIds() != null) {
            sb.append("ImageIds: ").append(imageIds()).append(",");
        }
        if (owners() != null) {
            sb.append("Owners: ").append(owners()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeImagesRequest> {
        /**
         * <p>
         * Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code>
         * (the sender of the request), or <code>all</code> (public AMIs).
         * </p>
         * 
         * @param executableUsers
         *        Scopes the images by users with explicit launch permissions. Specify an AWS account ID,
         *        <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableUsers(Collection<String> executableUsers);

        /**
         * <p>
         * Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code>
         * (the sender of the request), or <code>all</code> (public AMIs).
         * </p>
         * 
         * @param executableUsers
         *        Scopes the images by users with explicit launch permissions. Specify an AWS account ID,
         *        <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableUsers(String... executableUsers);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon
         * EBS volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         * <code>/dev/sdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> |
         * <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the image (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-public</code> - A Boolean that indicates whether the image is public.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manifest-location</code> - The location of the image manifest.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AMI (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> |
         * <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         * user-configured AWS account alias, which is set from the IAM console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the image owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of the product code (<code>devpay</code> | <code>marketplace</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - The message for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the tag-value
         * filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any
         * resources assigned both the tag key Purpose (regardless of what the tag's value is), and the tag value X
         * (regardless of what the tag's key is). If you want to list only resources where Purpose is X, see the
         * <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the
         *        Amazon EBS volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         *        <code>/dev/sdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> |
         *        <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the image (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
         *        <code>ramdisk</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is-public</code> - A Boolean that indicates whether the image is public.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manifest-location</code> - The location of the image manifest.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AMI (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> |
         *        <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         *        user-configured AWS account alias, which is set from the IAM console.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the image owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of the product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - The message for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        tag-value filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         *        "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
         *        value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon
         * EBS volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         * <code>/dev/sdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> |
         * <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the image (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-public</code> - A Boolean that indicates whether the image is public.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manifest-location</code> - The location of the image manifest.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AMI (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> |
         * <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         * user-configured AWS account alias, which is set from the IAM console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the image owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of the product code (<code>devpay</code> | <code>marketplace</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - The message for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the tag-value
         * filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any
         * resources assigned both the tag key Purpose (regardless of what the tag's value is), and the tag value X
         * (regardless of what the tag's key is). If you want to list only resources where Purpose is X, see the
         * <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the
         *        Amazon EBS volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         *        <code>/dev/sdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> |
         *        <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the image (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
         *        <code>ramdisk</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is-public</code> - A Boolean that indicates whether the image is public.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manifest-location</code> - The location of the image manifest.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AMI (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> |
         *        <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         *        user-configured AWS account alias, which is set from the IAM console.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the image owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of the product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - The message for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        tag-value filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         *        "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
         *        value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more image IDs.
         * </p>
         * <p>
         * Default: Describes all images available to you.
         * </p>
         * 
         * @param imageIds
         *        One or more image IDs.</p>
         *        <p>
         *        Default: Describes all images available to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<String> imageIds);

        /**
         * <p>
         * One or more image IDs.
         * </p>
         * <p>
         * Default: Describes all images available to you.
         * </p>
         * 
         * @param imageIds
         *        One or more image IDs.</p>
         *        <p>
         *        Default: Describes all images available to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(String... imageIds);

        /**
         * <p>
         * Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
         * request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code> |
         * <code>microsoft</code>). Omitting this option returns all images for which you have launch permissions,
         * regardless of ownership.
         * </p>
         * 
         * @param owners
         *        Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of
         *        the request), or an AWS owner alias (valid values are <code>amazon</code> |
         *        <code>aws-marketplace</code> | <code>microsoft</code>). Omitting this option returns all images for
         *        which you have launch permissions, regardless of ownership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(Collection<String> owners);

        /**
         * <p>
         * Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
         * request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code> |
         * <code>microsoft</code>). Omitting this option returns all images for which you have launch permissions,
         * regardless of ownership.
         * </p>
         * 
         * @param owners
         *        Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of
         *        the request), or an AWS owner alias (valid values are <code>amazon</code> |
         *        <code>aws-marketplace</code> | <code>microsoft</code>). Omitting this option returns all images for
         *        which you have launch permissions, regardless of ownership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(String... owners);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> executableUsers;

        private List<Filter> filters;

        private List<String> imageIds;

        private List<String> owners;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesRequest model) {
            setExecutableUsers(model.executableUsers);
            setFilters(model.filters);
            setImageIds(model.imageIds);
            setOwners(model.owners);
        }

        public final Collection<String> getExecutableUsers() {
            return executableUsers;
        }

        @Override
        public final Builder executableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executableUsers(String... executableUsers) {
            executableUsers(Arrays.asList(executableUsers));
            return this;
        }

        public final void setExecutableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getImageIds() {
            return imageIds;
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
        }

        public final Collection<String> getOwners() {
            return owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String... owners) {
            owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        @Override
        public DescribeImagesRequest build() {
            return new DescribeImagesRequest(this);
        }
    }
}
