/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeIdentityIdFormat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeIdentityIdFormatResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeIdentityIdFormatResponse.Builder, DescribeIdentityIdFormatResponse> {
    private final List<IdFormat> statuses;

    private DescribeIdentityIdFormatResponse(BuilderImpl builder) {
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * Information about the ID format for the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the ID format for the resources.
     */
    public List<IdFormat> statuses() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((statuses() == null) ? 0 : statuses().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityIdFormatResponse)) {
            return false;
        }
        DescribeIdentityIdFormatResponse other = (DescribeIdentityIdFormatResponse) obj;
        if (other.statuses() == null ^ this.statuses() == null) {
            return false;
        }
        if (other.statuses() != null && !other.statuses().equals(this.statuses())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (statuses() != null) {
            sb.append("Statuses: ").append(statuses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeIdentityIdFormatResponse> {
        /**
         * <p>
         * Information about the ID format for the resources.
         * </p>
         * 
         * @param statuses
         *        Information about the ID format for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<IdFormat> statuses);

        /**
         * <p>
         * Information about the ID format for the resources.
         * </p>
         * 
         * @param statuses
         *        Information about the ID format for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(IdFormat... statuses);
    }

    private static final class BuilderImpl implements Builder {
        private List<IdFormat> statuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityIdFormatResponse model) {
            setStatuses(model.statuses);
        }

        public final Collection<IdFormat> getStatuses() {
            return statuses;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
        }

        @Override
        public DescribeIdentityIdFormatResponse build() {
            return new DescribeIdentityIdFormatResponse(this);
        }
    }
}
