/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeIamInstanceProfileAssociationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeIamInstanceProfileAssociationsResponse.Builder, DescribeIamInstanceProfileAssociationsResponse> {
    private final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;

    private final String nextToken;

    private DescribeIamInstanceProfileAssociationsResponse(BuilderImpl builder) {
        this.iamInstanceProfileAssociations = builder.iamInstanceProfileAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more IAM instance profile associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more IAM instance profile associations.
     */
    public List<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        return iamInstanceProfileAssociations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((iamInstanceProfileAssociations() == null) ? 0 : iamInstanceProfileAssociations().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamInstanceProfileAssociationsResponse)) {
            return false;
        }
        DescribeIamInstanceProfileAssociationsResponse other = (DescribeIamInstanceProfileAssociationsResponse) obj;
        if (other.iamInstanceProfileAssociations() == null ^ this.iamInstanceProfileAssociations() == null) {
            return false;
        }
        if (other.iamInstanceProfileAssociations() != null
                && !other.iamInstanceProfileAssociations().equals(this.iamInstanceProfileAssociations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (iamInstanceProfileAssociations() != null) {
            sb.append("IamInstanceProfileAssociations: ").append(iamInstanceProfileAssociations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
        /**
         * <p>
         * Information about one or more IAM instance profile associations.
         * </p>
         * 
         * @param iamInstanceProfileAssociations
         *        Information about one or more IAM instance profile associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations);

        /**
         * <p>
         * Information about one or more IAM instance profile associations.
         * </p>
         * 
         * @param iamInstanceProfileAssociations
         *        Information about one or more IAM instance profile associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation... iamInstanceProfileAssociations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamInstanceProfileAssociationsResponse model) {
            setIamInstanceProfileAssociations(model.iamInstanceProfileAssociations);
            setNextToken(model.nextToken);
        }

        public final Collection<IamInstanceProfileAssociation> getIamInstanceProfileAssociations() {
            return iamInstanceProfileAssociations;
        }

        @Override
        public final Builder iamInstanceProfileAssociations(
                Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation... iamInstanceProfileAssociations) {
            iamInstanceProfileAssociations(Arrays.asList(iamInstanceProfileAssociations));
            return this;
        }

        public final void setIamInstanceProfileAssociations(
                Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIamInstanceProfileAssociationsResponse build() {
            return new DescribeIamInstanceProfileAssociationsResponse(this);
        }
    }
}
