/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostReservationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeHostReservationsRequest.Builder, DescribeHostReservationsRequest> {
    private final List<Filter> filter;

    private final List<String> hostReservationIdSet;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeHostReservationsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.hostReservationIdSet = builder.hostReservationIdSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     * <code>AllUpfront</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> |
     * <code>active</code> | <code>retired</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     *         <code>AllUpfront</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the reservation (<code>payment-pending</code> |
     *         <code>payment-failed</code> | <code>active</code> | <code>retired</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * One or more host reservation IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more host reservation IDs.
     */
    public List<String> hostReservationIdSet() {
        return hostReservationIdSet;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if
     * <code>maxResults</code> is given a larger value than 500, you will receive an error.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((hostReservationIdSet() == null) ? 0 : hostReservationIdSet().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsRequest)) {
            return false;
        }
        DescribeHostReservationsRequest other = (DescribeHostReservationsRequest) obj;
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.hostReservationIdSet() == null ^ this.hostReservationIdSet() == null) {
            return false;
        }
        if (other.hostReservationIdSet() != null && !other.hostReservationIdSet().equals(this.hostReservationIdSet())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (hostReservationIdSet() != null) {
            sb.append("HostReservationIdSet: ").append(hostReservationIdSet()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeHostReservationsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code>
         * | <code>active</code> | <code>retired</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the reservation (<code>payment-pending</code> |
         *        <code>payment-failed</code> | <code>active</code> | <code>retired</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code>
         * | <code>active</code> | <code>retired</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the reservation (<code>payment-pending</code> |
         *        <code>payment-failed</code> | <code>active</code> | <code>retired</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * One or more host reservation IDs.
         * </p>
         * 
         * @param hostReservationIdSet
         *        One or more host reservation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationIdSet(Collection<String> hostReservationIdSet);

        /**
         * <p>
         * One or more host reservation IDs.
         * </p>
         * 
         * @param hostReservationIdSet
         *        One or more host reservation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationIdSet(String... hostReservationIdSet);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filter;

        private List<String> hostReservationIdSet;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsRequest model) {
            setFilter(model.filter);
            setHostReservationIdSet(model.hostReservationIdSet);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
        }

        public final Collection<String> getHostReservationIdSet() {
            return hostReservationIdSet;
        }

        @Override
        public final Builder hostReservationIdSet(Collection<String> hostReservationIdSet) {
            this.hostReservationIdSet = HostReservationIdSetCopier.copy(hostReservationIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationIdSet(String... hostReservationIdSet) {
            hostReservationIdSet(Arrays.asList(hostReservationIdSet));
            return this;
        }

        public final void setHostReservationIdSet(Collection<String> hostReservationIdSet) {
            this.hostReservationIdSet = HostReservationIdSetCopier.copy(hostReservationIdSet);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostReservationsRequest build() {
            return new DescribeHostReservationsRequest(this);
        }
    }
}
