/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeExportTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeExportTasksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeExportTasksResponse.Builder, DescribeExportTasksResponse> {
    private final List<ExportTask> exportTasks;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        this.exportTasks = builder.exportTasks;
    }

    /**
     * <p>
     * Information about the export tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the export tasks.
     */
    public List<ExportTask> exportTasks() {
        return exportTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exportTasks() == null) ? 0 : exportTasks().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse) obj;
        if (other.exportTasks() == null ^ this.exportTasks() == null) {
            return false;
        }
        if (other.exportTasks() != null && !other.exportTasks().equals(this.exportTasks())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (exportTasks() != null) {
            sb.append("ExportTasks: ").append(exportTasks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeExportTasksResponse> {
        /**
         * <p>
         * Information about the export tasks.
         * </p>
         * 
         * @param exportTasks
         *        Information about the export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(Collection<ExportTask> exportTasks);

        /**
         * <p>
         * Information about the export tasks.
         * </p>
         * 
         * @param exportTasks
         *        Information about the export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(ExportTask... exportTasks);
    }

    private static final class BuilderImpl implements Builder {
        private List<ExportTask> exportTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            setExportTasks(model.exportTasks);
        }

        public final Collection<ExportTask> getExportTasks() {
            return exportTasks;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask... exportTasks) {
            exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copy(exportTasks);
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }
    }
}
