/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDhcpOptionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDhcpOptionsResponse.Builder, DescribeDhcpOptionsResponse> {
    private final List<DhcpOptions> dhcpOptions;

    private DescribeDhcpOptionsResponse(BuilderImpl builder) {
        this.dhcpOptions = builder.dhcpOptions;
    }

    /**
     * <p>
     * Information about one or more DHCP options sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more DHCP options sets.
     */
    public List<DhcpOptions> dhcpOptions() {
        return dhcpOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dhcpOptions() == null) ? 0 : dhcpOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsResponse)) {
            return false;
        }
        DescribeDhcpOptionsResponse other = (DescribeDhcpOptionsResponse) obj;
        if (other.dhcpOptions() == null ^ this.dhcpOptions() == null) {
            return false;
        }
        if (other.dhcpOptions() != null && !other.dhcpOptions().equals(this.dhcpOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dhcpOptions() != null) {
            sb.append("DhcpOptions: ").append(dhcpOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDhcpOptionsResponse> {
        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions);

        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions... dhcpOptions);
    }

    private static final class BuilderImpl implements Builder {
        private List<DhcpOptions> dhcpOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsResponse model) {
            setDhcpOptions(model.dhcpOptions);
        }

        public final Collection<DhcpOptions> getDhcpOptions() {
            return dhcpOptions;
        }

        @Override
        public final Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copy(dhcpOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(DhcpOptions... dhcpOptions) {
            dhcpOptions(Arrays.asList(dhcpOptions));
            return this;
        }

        public final void setDhcpOptions(Collection<DhcpOptions> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copy(dhcpOptions);
        }

        @Override
        public DescribeDhcpOptionsResponse build() {
            return new DescribeDhcpOptionsResponse(this);
        }
    }
}
