/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeAccountAttributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAccountAttributesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAccountAttributesResponse.Builder, DescribeAccountAttributesResponse> {
    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        this.accountAttributes = builder.accountAttributes;
    }

    /**
     * <p>
     * Information about one or more account attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more account attributes.
     */
    public List<AccountAttribute> accountAttributes() {
        return accountAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountAttributes() == null) ? 0 : accountAttributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse) obj;
        if (other.accountAttributes() == null ^ this.accountAttributes() == null) {
            return false;
        }
        if (other.accountAttributes() != null && !other.accountAttributes().equals(this.accountAttributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountAttributes() != null) {
            sb.append("AccountAttributes: ").append(accountAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        /**
         * <p>
         * Information about one or more account attributes.
         * </p>
         * 
         * @param accountAttributes
         *        Information about one or more account attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAttributes(Collection<AccountAttribute> accountAttributes);

        /**
         * <p>
         * Information about one or more account attributes.
         * </p>
         * 
         * @param accountAttributes
         *        Information about one or more account attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAttributes(AccountAttribute... accountAttributes);
    }

    private static final class BuilderImpl implements Builder {
        private List<AccountAttribute> accountAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            setAccountAttributes(model.accountAttributes);
        }

        public final Collection<AccountAttribute> getAccountAttributes() {
            return accountAttributes;
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute... accountAttributes) {
            accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        public final void setAccountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }
}
