/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteNetworkAclEntry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNetworkAclEntryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteNetworkAclEntryRequest.Builder, DeleteNetworkAclEntryRequest> {
    private final Boolean egress;

    private final String networkAclId;

    private final Integer ruleNumber;

    private DeleteNetworkAclEntryRequest(BuilderImpl builder) {
        this.egress = builder.egress;
        this.networkAclId = builder.networkAclId;
        this.ruleNumber = builder.ruleNumber;
    }

    /**
     * <p>
     * Indicates whether the rule is an egress rule.
     * </p>
     * 
     * @return Indicates whether the rule is an egress rule.
     */
    public Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The rule number of the entry to delete.
     * </p>
     * 
     * @return The rule number of the entry to delete.
     */
    public Integer ruleNumber() {
        return ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((egress() == null) ? 0 : egress().hashCode());
        hashCode = 31 * hashCode + ((networkAclId() == null) ? 0 : networkAclId().hashCode());
        hashCode = 31 * hashCode + ((ruleNumber() == null) ? 0 : ruleNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclEntryRequest)) {
            return false;
        }
        DeleteNetworkAclEntryRequest other = (DeleteNetworkAclEntryRequest) obj;
        if (other.egress() == null ^ this.egress() == null) {
            return false;
        }
        if (other.egress() != null && !other.egress().equals(this.egress())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.ruleNumber() == null ^ this.ruleNumber() == null) {
            return false;
        }
        if (other.ruleNumber() != null && !other.ruleNumber().equals(this.ruleNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (egress() != null) {
            sb.append("Egress: ").append(egress()).append(",");
        }
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        if (ruleNumber() != null) {
            sb.append("RuleNumber: ").append(ruleNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteNetworkAclEntryRequest> {
        /**
         * <p>
         * Indicates whether the rule is an egress rule.
         * </p>
         * 
         * @param egress
         *        Indicates whether the rule is an egress rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The rule number of the entry to delete.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number of the entry to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean egress;

        private String networkAclId;

        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclEntryRequest model) {
            setEgress(model.egress);
            setNetworkAclId(model.networkAclId);
            setRuleNumber(model.ruleNumber);
        }

        public final Boolean getEgress() {
            return egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public DeleteNetworkAclEntryRequest build() {
            return new DeleteNetworkAclEntryRequest(this);
        }
    }
}
