/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDhcpOptionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteDhcpOptionsRequest.Builder, DeleteDhcpOptionsRequest> {
    private final String dhcpOptionsId;

    private DeleteDhcpOptionsRequest(BuilderImpl builder) {
        this.dhcpOptionsId = builder.dhcpOptionsId;
    }

    /**
     * <p>
     * The ID of the DHCP options set.
     * </p>
     * 
     * @return The ID of the DHCP options set.
     */
    public String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dhcpOptionsId() == null) ? 0 : dhcpOptionsId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDhcpOptionsRequest)) {
            return false;
        }
        DeleteDhcpOptionsRequest other = (DeleteDhcpOptionsRequest) obj;
        if (other.dhcpOptionsId() == null ^ this.dhcpOptionsId() == null) {
            return false;
        }
        if (other.dhcpOptionsId() != null && !other.dhcpOptionsId().equals(this.dhcpOptionsId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(dhcpOptionsId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteDhcpOptionsRequest> {
        /**
         * <p>
         * The ID of the DHCP options set.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);
    }

    private static final class BuilderImpl implements Builder {
        private String dhcpOptionsId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDhcpOptionsRequest model) {
            setDhcpOptionsId(model.dhcpOptionsId);
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public DeleteDhcpOptionsRequest build() {
            return new DeleteDhcpOptionsRequest(this);
        }
    }
}
