/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVpcResponse.Builder, CreateVpcResponse> {
    private final Vpc vpc;

    private CreateVpcResponse(BuilderImpl builder) {
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * Information about the VPC.
     * </p>
     * 
     * @return Information about the VPC.
     */
    public Vpc vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpc() == null) ? 0 : vpc().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcResponse)) {
            return false;
        }
        CreateVpcResponse other = (CreateVpcResponse) obj;
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpc() != null) {
            sb.append("Vpc: ").append(vpc()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpcResponse> {
        /**
         * <p>
         * Information about the VPC.
         * </p>
         * 
         * @param vpc
         *        Information about the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(Vpc vpc);
    }

    private static final class BuilderImpl implements Builder {
        private Vpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcResponse model) {
            setVpc(model.vpc);
        }

        public final Vpc getVpc() {
            return vpc;
        }

        @Override
        public final Builder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(Vpc vpc) {
            this.vpc = vpc;
        }

        @Override
        public CreateVpcResponse build() {
            return new CreateVpcResponse(this);
        }
    }
}
