/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateSpotDatafeedSubscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSpotDatafeedSubscriptionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateSpotDatafeedSubscriptionResponse.Builder, CreateSpotDatafeedSubscriptionResponse> {
    private final SpotDatafeedSubscription spotDatafeedSubscription;

    private CreateSpotDatafeedSubscriptionResponse(BuilderImpl builder) {
        this.spotDatafeedSubscription = builder.spotDatafeedSubscription;
    }

    /**
     * <p>
     * The Spot instance data feed subscription.
     * </p>
     * 
     * @return The Spot instance data feed subscription.
     */
    public SpotDatafeedSubscription spotDatafeedSubscription() {
        return spotDatafeedSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((spotDatafeedSubscription() == null) ? 0 : spotDatafeedSubscription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpotDatafeedSubscriptionResponse)) {
            return false;
        }
        CreateSpotDatafeedSubscriptionResponse other = (CreateSpotDatafeedSubscriptionResponse) obj;
        if (other.spotDatafeedSubscription() == null ^ this.spotDatafeedSubscription() == null) {
            return false;
        }
        if (other.spotDatafeedSubscription() != null && !other.spotDatafeedSubscription().equals(this.spotDatafeedSubscription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (spotDatafeedSubscription() != null) {
            sb.append("SpotDatafeedSubscription: ").append(spotDatafeedSubscription()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateSpotDatafeedSubscriptionResponse> {
        /**
         * <p>
         * The Spot instance data feed subscription.
         * </p>
         * 
         * @param spotDatafeedSubscription
         *        The Spot instance data feed subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription);
    }

    private static final class BuilderImpl implements Builder {
        private SpotDatafeedSubscription spotDatafeedSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpotDatafeedSubscriptionResponse model) {
            setSpotDatafeedSubscription(model.spotDatafeedSubscription);
        }

        public final SpotDatafeedSubscription getSpotDatafeedSubscription() {
            return spotDatafeedSubscription;
        }

        @Override
        public final Builder spotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription) {
            this.spotDatafeedSubscription = spotDatafeedSubscription;
            return this;
        }

        public final void setSpotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription) {
            this.spotDatafeedSubscription = spotDatafeedSubscription;
        }

        @Override
        public CreateSpotDatafeedSubscriptionResponse build() {
            return new CreateSpotDatafeedSubscriptionResponse(this);
        }
    }
}
