/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateRouteTable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRouteTableResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateRouteTableResponse.Builder, CreateRouteTableResponse> {
    private final RouteTable routeTable;

    private CreateRouteTableResponse(BuilderImpl builder) {
        this.routeTable = builder.routeTable;
    }

    /**
     * <p>
     * Information about the route table.
     * </p>
     * 
     * @return Information about the route table.
     */
    public RouteTable routeTable() {
        return routeTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((routeTable() == null) ? 0 : routeTable().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteTableResponse)) {
            return false;
        }
        CreateRouteTableResponse other = (CreateRouteTableResponse) obj;
        if (other.routeTable() == null ^ this.routeTable() == null) {
            return false;
        }
        if (other.routeTable() != null && !other.routeTable().equals(this.routeTable())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (routeTable() != null) {
            sb.append("RouteTable: ").append(routeTable()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateRouteTableResponse> {
        /**
         * <p>
         * Information about the route table.
         * </p>
         * 
         * @param routeTable
         *        Information about the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTable(RouteTable routeTable);
    }

    private static final class BuilderImpl implements Builder {
        private RouteTable routeTable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteTableResponse model) {
            setRouteTable(model.routeTable);
        }

        public final RouteTable getRouteTable() {
            return routeTable;
        }

        @Override
        public final Builder routeTable(RouteTable routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public final void setRouteTable(RouteTable routeTable) {
            this.routeTable = routeTable;
        }

        @Override
        public CreateRouteTableResponse build() {
            return new CreateRouteTableResponse(this);
        }
    }
}
