/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreatePlacementGroup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePlacementGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreatePlacementGroupRequest.Builder, CreatePlacementGroupRequest> {
    private final String groupName;

    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    /**
     * <p>
     * A name for the placement group.
     * </p>
     * <p>
     * Constraints: Up to 255 ASCII characters
     * </p>
     * 
     * @return A name for the placement group.</p>
     *         <p>
     *         Constraints: Up to 255 ASCII characters
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public String strategy() {
        return strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((strategy() == null) ? 0 : strategy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest) obj;
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.strategy() == null ^ this.strategy() == null) {
            return false;
        }
        if (other.strategy() != null && !other.strategy().equals(this.strategy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (strategy() != null) {
            sb.append("Strategy: ").append(strategy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        /**
         * <p>
         * A name for the placement group.
         * </p>
         * <p>
         * Constraints: Up to 255 ASCII characters
         * </p>
         * 
         * @param groupName
         *        A name for the placement group.</p>
         *        <p>
         *        Constraints: Up to 255 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);
    }

    private static final class BuilderImpl implements Builder {
        private String groupName;

        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            setGroupName(model.groupName);
            setStrategy(model.strategy);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStrategy() {
            return strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }
    }
}
