/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for CreateInstanceExportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstanceExportTaskResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateInstanceExportTaskResponse.Builder, CreateInstanceExportTaskResponse> {
    private final ExportTask exportTask;

    private CreateInstanceExportTaskResponse(BuilderImpl builder) {
        this.exportTask = builder.exportTask;
    }

    /**
     * <p>
     * Information about the instance export task.
     * </p>
     * 
     * @return Information about the instance export task.
     */
    public ExportTask exportTask() {
        return exportTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exportTask() == null) ? 0 : exportTask().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskResponse)) {
            return false;
        }
        CreateInstanceExportTaskResponse other = (CreateInstanceExportTaskResponse) obj;
        if (other.exportTask() == null ^ this.exportTask() == null) {
            return false;
        }
        if (other.exportTask() != null && !other.exportTask().equals(this.exportTask())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (exportTask() != null) {
            sb.append("ExportTask: ").append(exportTask()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInstanceExportTaskResponse> {
        /**
         * <p>
         * Information about the instance export task.
         * </p>
         * 
         * @param exportTask
         *        Information about the instance export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTask(ExportTask exportTask);
    }

    private static final class BuilderImpl implements Builder {
        private ExportTask exportTask;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskResponse model) {
            setExportTask(model.exportTask);
        }

        public final ExportTask getExportTask() {
            return exportTask;
        }

        @Override
        public final Builder exportTask(ExportTask exportTask) {
            this.exportTask = exportTask;
            return this;
        }

        public final void setExportTask(ExportTask exportTask) {
            this.exportTask = exportTask;
        }

        @Override
        public CreateInstanceExportTaskResponse build() {
            return new CreateInstanceExportTaskResponse(this);
        }
    }
}
