/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot fleet request that was not successfully canceled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotFleetRequestsErrorItem implements
        ToCopyableBuilder<CancelSpotFleetRequestsErrorItem.Builder, CancelSpotFleetRequestsErrorItem> {
    private final CancelSpotFleetRequestsError error;

    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsErrorItem(BuilderImpl builder) {
        this.error = builder.error;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public CancelSpotFleetRequestsError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((error() == null) ? 0 : error().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestId() == null) ? 0 : spotFleetRequestId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsErrorItem)) {
            return false;
        }
        CancelSpotFleetRequestsErrorItem other = (CancelSpotFleetRequestsErrorItem) obj;
        if (other.error() == null ^ this.error() == null) {
            return false;
        }
        if (other.error() != null && !other.error().equals(this.error())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (error() != null) {
            sb.append("Error: ").append(error()).append(",");
        }
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotFleetRequestsErrorItem> {
        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(CancelSpotFleetRequestsError error);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    private static final class BuilderImpl implements Builder {
        private CancelSpotFleetRequestsError error;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsErrorItem model) {
            setError(model.error);
            setSpotFleetRequestId(model.spotFleetRequestId);
        }

        public final CancelSpotFleetRequestsError getError() {
            return error;
        }

        @Override
        public final Builder error(CancelSpotFleetRequestsError error) {
            this.error = error;
            return this;
        }

        public final void setError(CancelSpotFleetRequestsError error) {
            this.error = error;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public CancelSpotFleetRequestsErrorItem build() {
            return new CancelSpotFleetRequestsErrorItem(this);
        }
    }
}
