/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelImportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelImportTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelImportTaskRequest.Builder, CancelImportTaskRequest> {
    private final String cancelReason;

    private final String importTaskId;

    private CancelImportTaskRequest(BuilderImpl builder) {
        this.cancelReason = builder.cancelReason;
        this.importTaskId = builder.importTaskId;
    }

    /**
     * <p>
     * The reason for canceling the task.
     * </p>
     * 
     * @return The reason for canceling the task.
     */
    public String cancelReason() {
        return cancelReason;
    }

    /**
     * <p>
     * The ID of the import image or import snapshot task to be canceled.
     * </p>
     * 
     * @return The ID of the import image or import snapshot task to be canceled.
     */
    public String importTaskId() {
        return importTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cancelReason() == null) ? 0 : cancelReason().hashCode());
        hashCode = 31 * hashCode + ((importTaskId() == null) ? 0 : importTaskId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskRequest)) {
            return false;
        }
        CancelImportTaskRequest other = (CancelImportTaskRequest) obj;
        if (other.cancelReason() == null ^ this.cancelReason() == null) {
            return false;
        }
        if (other.cancelReason() != null && !other.cancelReason().equals(this.cancelReason())) {
            return false;
        }
        if (other.importTaskId() == null ^ this.importTaskId() == null) {
            return false;
        }
        if (other.importTaskId() != null && !other.importTaskId().equals(this.importTaskId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cancelReason() != null) {
            sb.append("CancelReason: ").append(cancelReason()).append(",");
        }
        if (importTaskId() != null) {
            sb.append("ImportTaskId: ").append(importTaskId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelImportTaskRequest> {
        /**
         * <p>
         * The reason for canceling the task.
         * </p>
         * 
         * @param cancelReason
         *        The reason for canceling the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelReason(String cancelReason);

        /**
         * <p>
         * The ID of the import image or import snapshot task to be canceled.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import image or import snapshot task to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);
    }

    private static final class BuilderImpl implements Builder {
        private String cancelReason;

        private String importTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskRequest model) {
            setCancelReason(model.cancelReason);
            setImportTaskId(model.importTaskId);
        }

        public final String getCancelReason() {
            return cancelReason;
        }

        @Override
        public final Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public final void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public CancelImportTaskRequest build() {
            return new CancelImportTaskRequest(this);
        }
    }
}
