/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AttachVpnGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachVpnGatewayResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AttachVpnGatewayResponse.Builder, AttachVpnGatewayResponse> {
    private final VpcAttachment vpcAttachment;

    private AttachVpnGatewayResponse(BuilderImpl builder) {
        this.vpcAttachment = builder.vpcAttachment;
    }

    /**
     * <p>
     * Information about the attachment.
     * </p>
     * 
     * @return Information about the attachment.
     */
    public VpcAttachment vpcAttachment() {
        return vpcAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcAttachment() == null) ? 0 : vpcAttachment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVpnGatewayResponse)) {
            return false;
        }
        AttachVpnGatewayResponse other = (AttachVpnGatewayResponse) obj;
        if (other.vpcAttachment() == null ^ this.vpcAttachment() == null) {
            return false;
        }
        if (other.vpcAttachment() != null && !other.vpcAttachment().equals(this.vpcAttachment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcAttachment() != null) {
            sb.append("VpcAttachment: ").append(vpcAttachment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AttachVpnGatewayResponse> {
        /**
         * <p>
         * Information about the attachment.
         * </p>
         * 
         * @param vpcAttachment
         *        Information about the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachment(VpcAttachment vpcAttachment);
    }

    private static final class BuilderImpl implements Builder {
        private VpcAttachment vpcAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVpnGatewayResponse model) {
            setVpcAttachment(model.vpcAttachment);
        }

        public final VpcAttachment getVpcAttachment() {
            return vpcAttachment;
        }

        @Override
        public final Builder vpcAttachment(VpcAttachment vpcAttachment) {
            this.vpcAttachment = vpcAttachment;
            return this;
        }

        public final void setVpcAttachment(VpcAttachment vpcAttachment) {
            this.vpcAttachment = vpcAttachment;
        }

        @Override
        public AttachVpnGatewayResponse build() {
            return new AttachVpnGatewayResponse(this);
        }
    }
}
