/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AttachVpnGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachVpnGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AttachVpnGatewayRequest.Builder, AttachVpnGatewayRequest> {
    private final String vpcId;

    private final String vpnGatewayId;

    private AttachVpnGatewayRequest(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.vpnGatewayId = builder.vpnGatewayId;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((vpnGatewayId() == null) ? 0 : vpnGatewayId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVpnGatewayRequest)) {
            return false;
        }
        AttachVpnGatewayRequest other = (AttachVpnGatewayRequest) obj;
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(vpnGatewayId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AttachVpnGatewayRequest> {
        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);
    }

    private static final class BuilderImpl implements Builder {
        private String vpcId;

        private String vpnGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVpnGatewayRequest model) {
            setVpcId(model.vpcId);
            setVpnGatewayId(model.vpnGatewayId);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public AttachVpnGatewayRequest build() {
            return new AttachVpnGatewayRequest(this);
        }
    }
}
