/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the VolumeAttachment object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachVolumeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AttachVolumeResponse.Builder, AttachVolumeResponse> {
    private final VolumeAttachment attachment;

    private AttachVolumeResponse(BuilderImpl builder) {
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * Describes volume attachment details.
     * </p>
     * 
     * @return Describes volume attachment details.
     */
    public VolumeAttachment attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attachment() == null) ? 0 : attachment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeResponse)) {
            return false;
        }
        AttachVolumeResponse other = (AttachVolumeResponse) obj;
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attachment() != null) {
            sb.append("Attachment: ").append(attachment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AttachVolumeResponse> {
        /**
         * <p>
         * Describes volume attachment details.
         * </p>
         * 
         * @param attachment
         *        Describes volume attachment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(VolumeAttachment attachment);
    }

    private static final class BuilderImpl implements Builder {
        private VolumeAttachment attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVolumeResponse model) {
            setAttachment(model.attachment);
        }

        public final VolumeAttachment getAttachment() {
            return attachment;
        }

        @Override
        public final Builder attachment(VolumeAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(VolumeAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public AttachVolumeResponse build() {
            return new AttachVolumeResponse(this);
        }
    }
}
