/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an account attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AccountAttribute implements ToCopyableBuilder<AccountAttribute.Builder, AccountAttribute> {
    private final String attributeName;

    private final List<AccountAttributeValue> attributeValues;

    private AccountAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    /**
     * <p>
     * The name of the account attribute.
     * </p>
     * 
     * @return The name of the account attribute.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * One or more values for the account attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values for the account attribute.
     */
    public List<AccountAttributeValue> attributeValues() {
        return attributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributeName() == null) ? 0 : attributeName().hashCode());
        hashCode = 31 * hashCode + ((attributeValues() == null) ? 0 : attributeValues().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute) obj;
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValues() == null ^ this.attributeValues() == null) {
            return false;
        }
        if (other.attributeValues() != null && !other.attributeValues().equals(this.attributeValues())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        if (attributeValues() != null) {
            sb.append("AttributeValues: ").append(attributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AccountAttribute> {
        /**
         * <p>
         * The name of the account attribute.
         * </p>
         * 
         * @param attributeName
         *        The name of the account attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * One or more values for the account attribute.
         * </p>
         * 
         * @param attributeValues
         *        One or more values for the account attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(Collection<AccountAttributeValue> attributeValues);

        /**
         * <p>
         * One or more values for the account attribute.
         * </p>
         * 
         * @param attributeValues
         *        One or more values for the account attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(AccountAttributeValue... attributeValues);
    }

    private static final class BuilderImpl implements Builder {
        private String attributeName;

        private List<AccountAttributeValue> attributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            setAttributeName(model.attributeName);
            setAttributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<AccountAttributeValue> getAttributeValues() {
            return attributeValues;
        }

        @Override
        public final Builder attributeValues(Collection<AccountAttributeValue> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(AccountAttributeValue... attributeValues) {
            attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public final void setAttributeValues(Collection<AccountAttributeValue> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copy(attributeValues);
        }

        @Override
        public AccountAttribute build() {
            return new AccountAttribute(this);
        }
    }
}
