/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the exchange and whether it was <code>successful</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AcceptReservedInstancesExchangeQuoteResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AcceptReservedInstancesExchangeQuoteResponse.Builder, AcceptReservedInstancesExchangeQuoteResponse> {
    private final String exchangeId;

    private AcceptReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        this.exchangeId = builder.exchangeId;
    }

    /**
     * <p>
     * The ID of the successful exchange.
     * </p>
     * 
     * @return The ID of the successful exchange.
     */
    public String exchangeId() {
        return exchangeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exchangeId() == null) ? 0 : exchangeId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        AcceptReservedInstancesExchangeQuoteResponse other = (AcceptReservedInstancesExchangeQuoteResponse) obj;
        if (other.exchangeId() == null ^ this.exchangeId() == null) {
            return false;
        }
        if (other.exchangeId() != null && !other.exchangeId().equals(this.exchangeId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (exchangeId() != null) {
            sb.append("ExchangeId: ").append(exchangeId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AcceptReservedInstancesExchangeQuoteResponse> {
        /**
         * <p>
         * The ID of the successful exchange.
         * </p>
         * 
         * @param exchangeId
         *        The ID of the successful exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exchangeId(String exchangeId);
    }

    private static final class BuilderImpl implements Builder {
        private String exchangeId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptReservedInstancesExchangeQuoteResponse model) {
            setExchangeId(model.exchangeId);
        }

        public final String getExchangeId() {
            return exchangeId;
        }

        @Override
        public final Builder exchangeId(String exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        public final void setExchangeId(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        @Override
        public AcceptReservedInstancesExchangeQuoteResponse build() {
            return new AcceptReservedInstancesExchangeQuoteResponse(this);
        }
    }
}
