/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ReservedInstancesModification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReservedInstancesModificationUnmarshaller implements
        Unmarshaller<ReservedInstancesModification, StaxUnmarshallerContext> {

    public ReservedInstancesModification unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstancesModification.Builder reservedInstancesModification = ReservedInstancesModification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ReservedInstancesModificationResult> modificationResults = null;
        java.util.List<ReservedInstancesId> reservedInstancesIds = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                reservedInstancesModification.modificationResults(modificationResults);
                reservedInstancesModification.reservedInstancesIds(reservedInstancesIds);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("clientToken", targetDepth)) {
                    reservedInstancesModification.clientToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("createDate", targetDepth)) {
                    reservedInstancesModification.createDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("effectiveDate", targetDepth)) {
                    reservedInstancesModification.effectiveDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("modificationResultSet", targetDepth)) {
                    modificationResults = new ArrayList<ReservedInstancesModificationResult>();
                    continue;
                }

                if (context.testExpression("modificationResultSet/item", targetDepth)) {
                    modificationResults.add(ReservedInstancesModificationResultUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstancesSet", targetDepth)) {
                    reservedInstancesIds = new ArrayList<ReservedInstancesId>();
                    continue;
                }

                if (context.testExpression("reservedInstancesSet/item", targetDepth)) {
                    reservedInstancesIds.add(ReservedInstancesIdUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstancesModificationId", targetDepth)) {
                    reservedInstancesModification.reservedInstancesModificationId(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    reservedInstancesModification.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("statusMessage", targetDepth)) {
                    reservedInstancesModification.statusMessage(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("updateDate", targetDepth)) {
                    reservedInstancesModification.updateDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    reservedInstancesModification.modificationResults(modificationResults);
                    reservedInstancesModification.reservedInstancesIds(reservedInstancesIds);
                    break;
                }
            }
        }
        return reservedInstancesModification.build();
    }

    private static ReservedInstancesModificationUnmarshaller INSTANCE;

    public static ReservedInstancesModificationUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ReservedInstancesModificationUnmarshaller();
        return INSTANCE;
    }
}
