/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ReservedInstancesListing StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReservedInstancesListingUnmarshaller implements Unmarshaller<ReservedInstancesListing, StaxUnmarshallerContext> {

    public ReservedInstancesListing unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstancesListing.Builder reservedInstancesListing = ReservedInstancesListing.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InstanceCount> instanceCounts = null;
        java.util.List<PriceSchedule> priceSchedules = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                reservedInstancesListing.instanceCounts(instanceCounts);
                reservedInstancesListing.priceSchedules(priceSchedules);
                reservedInstancesListing.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("clientToken", targetDepth)) {
                    reservedInstancesListing.clientToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("createDate", targetDepth)) {
                    reservedInstancesListing.createDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceCounts", targetDepth)) {
                    instanceCounts = new ArrayList<InstanceCount>();
                    continue;
                }

                if (context.testExpression("instanceCounts/item", targetDepth)) {
                    instanceCounts.add(InstanceCountUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("priceSchedules", targetDepth)) {
                    priceSchedules = new ArrayList<PriceSchedule>();
                    continue;
                }

                if (context.testExpression("priceSchedules/item", targetDepth)) {
                    priceSchedules.add(PriceScheduleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstancesId", targetDepth)) {
                    reservedInstancesListing.reservedInstancesId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstancesListingId", targetDepth)) {
                    reservedInstancesListing.reservedInstancesListingId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    reservedInstancesListing.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("statusMessage", targetDepth)) {
                    reservedInstancesListing.statusMessage(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("updateDate", targetDepth)) {
                    reservedInstancesListing.updateDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    reservedInstancesListing.instanceCounts(instanceCounts);
                    reservedInstancesListing.priceSchedules(priceSchedules);
                    reservedInstancesListing.tags(tags);
                    break;
                }
            }
        }
        return reservedInstancesListing.build();
    }

    private static ReservedInstancesListingUnmarshaller INSTANCE;

    public static ReservedInstancesListingUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ReservedInstancesListingUnmarshaller();
        return INSTANCE;
    }
}
