/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * NetworkAcl StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NetworkAclUnmarshaller implements Unmarshaller<NetworkAcl, StaxUnmarshallerContext> {

    public NetworkAcl unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkAcl.Builder networkAcl = NetworkAcl.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<NetworkAclAssociation> associations = null;
        java.util.List<NetworkAclEntry> entries = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                networkAcl.associations(associations);
                networkAcl.entries(entries);
                networkAcl.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("associationSet", targetDepth)) {
                    associations = new ArrayList<NetworkAclAssociation>();
                    continue;
                }

                if (context.testExpression("associationSet/item", targetDepth)) {
                    associations.add(NetworkAclAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("entrySet", targetDepth)) {
                    entries = new ArrayList<NetworkAclEntry>();
                    continue;
                }

                if (context.testExpression("entrySet/item", targetDepth)) {
                    entries.add(NetworkAclEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("default", targetDepth)) {
                    networkAcl.isDefault(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkAclId", targetDepth)) {
                    networkAcl.networkAclId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    networkAcl.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    networkAcl.associations(associations);
                    networkAcl.entries(entries);
                    networkAcl.tags(tags);
                    break;
                }
            }
        }
        return networkAcl.build();
    }

    private static NetworkAclUnmarshaller INSTANCE;

    public static NetworkAclUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new NetworkAclUnmarshaller();
        return INSTANCE;
    }
}
