/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * ModifyInstanceAttributeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyInstanceAttributeRequestMarshaller implements
        Marshaller<Request<ModifyInstanceAttributeRequest>, ModifyInstanceAttributeRequest> {

    public Request<ModifyInstanceAttributeRequest> marshall(ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {

        if (modifyInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyInstanceAttributeRequest> request = new DefaultRequest<ModifyInstanceAttributeRequest>(
                modifyInstanceAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyInstanceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value",
                    StringUtils.fromBoolean(modifyInstanceAttributeRequest.sourceDestCheck()));
        }

        if (modifyInstanceAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyInstanceAttributeRequest.attribute()));
        }

        java.util.List<InstanceBlockDeviceMappingSpecification> modifyInstanceAttributeRequestBlockDeviceMappingsList = modifyInstanceAttributeRequest
                .blockDeviceMappings();
        if (modifyInstanceAttributeRequestBlockDeviceMappingsList != null) {
            int blockDeviceMappingsListIndex = 1;

            for (InstanceBlockDeviceMappingSpecification modifyInstanceAttributeRequestBlockDeviceMappingsListValue : modifyInstanceAttributeRequestBlockDeviceMappingsList) {

                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName",
                            StringUtils.fromString(modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName()));
                }

                EbsInstanceBlockDeviceSpecification ebs = modifyInstanceAttributeRequestBlockDeviceMappingsListValue.ebs();
                if (ebs != null) {

                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination",
                                StringUtils.fromBoolean(ebs.deleteOnTermination()));
                    }

                    if (ebs.volumeId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeId",
                                StringUtils.fromString(ebs.volumeId()));
                    }
                }

                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice",
                            StringUtils.fromString(modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice()));
                }

                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName",
                            StringUtils.fromString(modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName()));
                }
                blockDeviceMappingsListIndex++;
            }
        }

        if (modifyInstanceAttributeRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination.Value",
                    StringUtils.fromBoolean(modifyInstanceAttributeRequest.disableApiTermination()));
        }

        if (modifyInstanceAttributeRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.ebsOptimized()));
        }

        if (modifyInstanceAttributeRequest.enaSupport() != null) {
            request.addParameter("EnaSupport.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.enaSupport()));
        }

        java.util.List<String> modifyInstanceAttributeRequestGroupsList = modifyInstanceAttributeRequest.groups();
        if (modifyInstanceAttributeRequestGroupsList != null) {
            int groupsListIndex = 1;

            for (String modifyInstanceAttributeRequestGroupsListValue : modifyInstanceAttributeRequestGroupsList) {
                if (modifyInstanceAttributeRequestGroupsListValue != null) {
                    request.addParameter("GroupId." + groupsListIndex,
                            StringUtils.fromString(modifyInstanceAttributeRequestGroupsListValue));
                }
                groupsListIndex++;
            }
        }

        if (modifyInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(modifyInstanceAttributeRequest.instanceId()));
        }

        if (modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior.Value",
                    StringUtils.fromString(modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior()));
        }

        if (modifyInstanceAttributeRequest.instanceType() != null) {
            request.addParameter("InstanceType.Value", StringUtils.fromString(modifyInstanceAttributeRequest.instanceType()));
        }

        if (modifyInstanceAttributeRequest.kernel() != null) {
            request.addParameter("Kernel.Value", StringUtils.fromString(modifyInstanceAttributeRequest.kernel()));
        }

        if (modifyInstanceAttributeRequest.ramdisk() != null) {
            request.addParameter("Ramdisk.Value", StringUtils.fromString(modifyInstanceAttributeRequest.ramdisk()));
        }

        if (modifyInstanceAttributeRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport.Value",
                    StringUtils.fromString(modifyInstanceAttributeRequest.sriovNetSupport()));
        }

        if (modifyInstanceAttributeRequest.userData() != null) {
            request.addParameter("UserData.Value", StringUtils.fromString(modifyInstanceAttributeRequest.userData()));
        }

        if (modifyInstanceAttributeRequest.value() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyInstanceAttributeRequest.value()));
        }

        return request;
    }

}
