/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Host StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HostUnmarshaller implements Unmarshaller<Host, StaxUnmarshallerContext> {

    public Host unmarshall(StaxUnmarshallerContext context) throws Exception {
        Host.Builder host = Host.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HostInstance> instances = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                host.instances(instances);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("autoPlacement", targetDepth)) {
                    host.autoPlacement(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availabilityZone", targetDepth)) {
                    host.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availableCapacity", targetDepth)) {
                    host.availableCapacity(AvailableCapacityUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("clientToken", targetDepth)) {
                    host.clientToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hostId", targetDepth)) {
                    host.hostId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hostProperties", targetDepth)) {
                    host.hostProperties(HostPropertiesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hostReservationId", targetDepth)) {
                    host.hostReservationId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instances", targetDepth)) {
                    instances = new ArrayList<HostInstance>();
                    continue;
                }

                if (context.testExpression("instances/item", targetDepth)) {
                    instances.add(HostInstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    host.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    host.instances(instances);
                    break;
                }
            }
        }
        return host.build();
    }

    private static HostUnmarshaller INSTANCE;

    public static HostUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new HostUnmarshaller();
        return INSTANCE;
    }
}
