/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ExportToS3Task StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ExportToS3TaskUnmarshaller implements Unmarshaller<ExportToS3Task, StaxUnmarshallerContext> {

    public ExportToS3Task unmarshall(StaxUnmarshallerContext context) throws Exception {
        ExportToS3Task.Builder exportToS3Task = ExportToS3Task.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("containerFormat", targetDepth)) {
                    exportToS3Task.containerFormat(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("diskImageFormat", targetDepth)) {
                    exportToS3Task.diskImageFormat(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("s3Bucket", targetDepth)) {
                    exportToS3Task.s3Bucket(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("s3Key", targetDepth)) {
                    exportToS3Task.s3Key(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return exportToS3Task.build();
    }

    private static ExportToS3TaskUnmarshaller INSTANCE;

    public static ExportToS3TaskUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ExportToS3TaskUnmarshaller();
        return INSTANCE;
    }
}
