/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeSpotFleetRequestHistoryResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSpotFleetRequestHistoryResponseUnmarshaller implements
        Unmarshaller<DescribeSpotFleetRequestHistoryResponse, StaxUnmarshallerContext> {

    public DescribeSpotFleetRequestHistoryResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeSpotFleetRequestHistoryResponse.Builder describeSpotFleetRequestHistoryResponse = DescribeSpotFleetRequestHistoryResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HistoryRecord> historyRecords = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeSpotFleetRequestHistoryResponse.historyRecords(historyRecords);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("historyRecordSet", targetDepth)) {
                    historyRecords = new ArrayList<HistoryRecord>();
                    continue;
                }

                if (context.testExpression("historyRecordSet/item", targetDepth)) {
                    historyRecords.add(HistoryRecordUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("lastEvaluatedTime", targetDepth)) {
                    describeSpotFleetRequestHistoryResponse.lastEvaluatedTime(InstantUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeSpotFleetRequestHistoryResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotFleetRequestId", targetDepth)) {
                    describeSpotFleetRequestHistoryResponse.spotFleetRequestId(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("startTime", targetDepth)) {
                    describeSpotFleetRequestHistoryResponse.startTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeSpotFleetRequestHistoryResponse.historyRecords(historyRecords);
                    break;
                }
            }
        }
        return describeSpotFleetRequestHistoryResponse.build();
    }

    private static DescribeSpotFleetRequestHistoryResponseUnmarshaller INSTANCE;

    public static DescribeSpotFleetRequestHistoryResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DescribeSpotFleetRequestHistoryResponseUnmarshaller();
        return INSTANCE;
    }
}
