/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeInstanceStatusResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeInstanceStatusResponseUnmarshaller implements
        Unmarshaller<DescribeInstanceStatusResponse, StaxUnmarshallerContext> {

    public DescribeInstanceStatusResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeInstanceStatusResponse.Builder describeInstanceStatusResponse = DescribeInstanceStatusResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InstanceStatus> instanceStatuses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeInstanceStatusResponse.instanceStatuses(instanceStatuses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("instanceStatusSet", targetDepth)) {
                    instanceStatuses = new ArrayList<InstanceStatus>();
                    continue;
                }

                if (context.testExpression("instanceStatusSet/item", targetDepth)) {
                    instanceStatuses.add(InstanceStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeInstanceStatusResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeInstanceStatusResponse.instanceStatuses(instanceStatuses);
                    break;
                }
            }
        }
        return describeInstanceStatusResponse.build();
    }

    private static DescribeInstanceStatusResponseUnmarshaller INSTANCE;

    public static DescribeInstanceStatusResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DescribeInstanceStatusResponseUnmarshaller();
        return INSTANCE;
    }
}
