/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * CreateRouteRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateRouteRequestMarshaller implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {

    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {

        if (createRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateRouteRequest> request = new DefaultRequest<CreateRouteRequest>(createRouteRequest, "EC2Client");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(createRouteRequest.destinationCidrBlock()));
        }

        if (createRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock",
                    StringUtils.fromString(createRouteRequest.destinationIpv6CidrBlock()));
        }

        if (createRouteRequest.egressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId",
                    StringUtils.fromString(createRouteRequest.egressOnlyInternetGatewayId()));
        }

        if (createRouteRequest.gatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString(createRouteRequest.gatewayId()));
        }

        if (createRouteRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createRouteRequest.instanceId()));
        }

        if (createRouteRequest.natGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString(createRouteRequest.natGatewayId()));
        }

        if (createRouteRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(createRouteRequest.networkInterfaceId()));
        }

        if (createRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(createRouteRequest.routeTableId()));
        }

        if (createRouteRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString(createRouteRequest.vpcPeeringConnectionId()));
        }

        return request;
    }

}
