/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcPeeringConnection implements ToCopyableBuilder<VpcPeeringConnection.Builder, VpcPeeringConnection> {
    private final VpcPeeringConnectionVpcInfo accepterVpcInfo;

    private final Instant expirationTime;

    private final VpcPeeringConnectionVpcInfo requesterVpcInfo;

    private final VpcPeeringConnectionStateReason status;

    private final List<Tag> tags;

    private final String vpcPeeringConnectionId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering
     * connection.
     * </p>
     * 
     * @return Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
     *         peering connection.
     */
    public VpcPeeringConnectionVpcInfo accepterVpcInfo() {
        return accepterVpcInfo;
    }

    /**
     * <p>
     * The time that an unaccepted VPC peering connection will expire.
     * </p>
     * 
     * @return The time that an unaccepted VPC peering connection will expire.
     */
    public Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
     * peering connection.
     * </p>
     * 
     * @return Information about the requester VPC. CIDR block information is only returned when describing an active
     *         VPC peering connection.
     */
    public VpcPeeringConnectionVpcInfo requesterVpcInfo() {
        return requesterVpcInfo;
    }

    /**
     * <p>
     * The status of the VPC peering connection.
     * </p>
     * 
     * @return The status of the VPC peering connection.
     */
    public VpcPeeringConnectionStateReason status() {
        return status;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accepterVpcInfo() == null) ? 0 : accepterVpcInfo().hashCode());
        hashCode = 31 * hashCode + ((expirationTime() == null) ? 0 : expirationTime().hashCode());
        hashCode = 31 * hashCode + ((requesterVpcInfo() == null) ? 0 : requesterVpcInfo().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection) obj;
        if (other.accepterVpcInfo() == null ^ this.accepterVpcInfo() == null) {
            return false;
        }
        if (other.accepterVpcInfo() != null && !other.accepterVpcInfo().equals(this.accepterVpcInfo())) {
            return false;
        }
        if (other.expirationTime() == null ^ this.expirationTime() == null) {
            return false;
        }
        if (other.expirationTime() != null && !other.expirationTime().equals(this.expirationTime())) {
            return false;
        }
        if (other.requesterVpcInfo() == null ^ this.requesterVpcInfo() == null) {
            return false;
        }
        if (other.requesterVpcInfo() != null && !other.requesterVpcInfo().equals(this.requesterVpcInfo())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accepterVpcInfo() != null) {
            sb.append("AccepterVpcInfo: ").append(accepterVpcInfo()).append(",");
        }
        if (expirationTime() != null) {
            sb.append("ExpirationTime: ").append(expirationTime()).append(",");
        }
        if (requesterVpcInfo() != null) {
            sb.append("RequesterVpcInfo: ").append(requesterVpcInfo()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VpcPeeringConnection> {
        /**
         * <p>
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * 
         * @param accepterVpcInfo
         *        Information about the accepter VPC. CIDR block information is only returned when describing an active
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo);

        /**
         * <p>
         * The time that an unaccepted VPC peering connection will expire.
         * </p>
         * 
         * @param expirationTime
         *        The time that an unaccepted VPC peering connection will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * 
         * @param requesterVpcInfo
         *        Information about the requester VPC. CIDR block information is only returned when describing an active
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo);

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * 
         * @param status
         *        The status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VpcPeeringConnectionStateReason status);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    private static final class BuilderImpl implements Builder {
        private VpcPeeringConnectionVpcInfo accepterVpcInfo;

        private Instant expirationTime;

        private VpcPeeringConnectionVpcInfo requesterVpcInfo;

        private VpcPeeringConnectionStateReason status;

        private List<Tag> tags;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            setAccepterVpcInfo(model.accepterVpcInfo);
            setExpirationTime(model.expirationTime);
            setRequesterVpcInfo(model.requesterVpcInfo);
            setStatus(model.status);
            setTags(model.tags);
            setVpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final VpcPeeringConnectionVpcInfo getAccepterVpcInfo() {
            return accepterVpcInfo;
        }

        @Override
        public final Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final VpcPeeringConnectionVpcInfo getRequesterVpcInfo() {
            return requesterVpcInfo;
        }

        @Override
        public final Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
        }

        public final VpcPeeringConnectionStateReason getStatus() {
            return status;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStateReason status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VpcPeeringConnectionStateReason status) {
            this.status = status;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }
    }
}
