/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes telemetry for a VPN tunnel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VgwTelemetry implements ToCopyableBuilder<VgwTelemetry.Builder, VgwTelemetry> {
    private final Integer acceptedRouteCount;

    private final Instant lastStatusChange;

    private final String outsideIpAddress;

    private final String status;

    private final String statusMessage;

    private VgwTelemetry(BuilderImpl builder) {
        this.acceptedRouteCount = builder.acceptedRouteCount;
        this.lastStatusChange = builder.lastStatusChange;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The number of accepted routes.
     * </p>
     * 
     * @return The number of accepted routes.
     */
    public Integer acceptedRouteCount() {
        return acceptedRouteCount;
    }

    /**
     * <p>
     * The date and time of the last change in status.
     * </p>
     * 
     * @return The date and time of the last change in status.
     */
    public Instant lastStatusChange() {
        return lastStatusChange;
    }

    /**
     * <p>
     * The Internet-routable IP address of the virtual private gateway's outside interface.
     * </p>
     * 
     * @return The Internet-routable IP address of the virtual private gateway's outside interface.
     */
    public String outsideIpAddress() {
        return outsideIpAddress;
    }

    /**
     * <p>
     * The status of the VPN tunnel.
     * </p>
     * 
     * @return The status of the VPN tunnel.
     * @see TelemetryStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurs, a description of the error.
     * </p>
     * 
     * @return If an error occurs, a description of the error.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((acceptedRouteCount() == null) ? 0 : acceptedRouteCount().hashCode());
        hashCode = 31 * hashCode + ((lastStatusChange() == null) ? 0 : lastStatusChange().hashCode());
        hashCode = 31 * hashCode + ((outsideIpAddress() == null) ? 0 : outsideIpAddress().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VgwTelemetry)) {
            return false;
        }
        VgwTelemetry other = (VgwTelemetry) obj;
        if (other.acceptedRouteCount() == null ^ this.acceptedRouteCount() == null) {
            return false;
        }
        if (other.acceptedRouteCount() != null && !other.acceptedRouteCount().equals(this.acceptedRouteCount())) {
            return false;
        }
        if (other.lastStatusChange() == null ^ this.lastStatusChange() == null) {
            return false;
        }
        if (other.lastStatusChange() != null && !other.lastStatusChange().equals(this.lastStatusChange())) {
            return false;
        }
        if (other.outsideIpAddress() == null ^ this.outsideIpAddress() == null) {
            return false;
        }
        if (other.outsideIpAddress() != null && !other.outsideIpAddress().equals(this.outsideIpAddress())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (acceptedRouteCount() != null) {
            sb.append("AcceptedRouteCount: ").append(acceptedRouteCount()).append(",");
        }
        if (lastStatusChange() != null) {
            sb.append("LastStatusChange: ").append(lastStatusChange()).append(",");
        }
        if (outsideIpAddress() != null) {
            sb.append("OutsideIpAddress: ").append(outsideIpAddress()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VgwTelemetry> {
        /**
         * <p>
         * The number of accepted routes.
         * </p>
         * 
         * @param acceptedRouteCount
         *        The number of accepted routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedRouteCount(Integer acceptedRouteCount);

        /**
         * <p>
         * The date and time of the last change in status.
         * </p>
         * 
         * @param lastStatusChange
         *        The date and time of the last change in status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(Instant lastStatusChange);

        /**
         * <p>
         * The Internet-routable IP address of the virtual private gateway's outside interface.
         * </p>
         * 
         * @param outsideIpAddress
         *        The Internet-routable IP address of the virtual private gateway's outside interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outsideIpAddress(String outsideIpAddress);

        /**
         * <p>
         * The status of the VPN tunnel.
         * </p>
         * 
         * @param status
         *        The status of the VPN tunnel.
         * @see TelemetryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the VPN tunnel.
         * </p>
         * 
         * @param status
         *        The status of the VPN tunnel.
         * @see TelemetryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryStatus
         */
        Builder status(TelemetryStatus status);

        /**
         * <p>
         * If an error occurs, a description of the error.
         * </p>
         * 
         * @param statusMessage
         *        If an error occurs, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    private static final class BuilderImpl implements Builder {
        private Integer acceptedRouteCount;

        private Instant lastStatusChange;

        private String outsideIpAddress;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VgwTelemetry model) {
            setAcceptedRouteCount(model.acceptedRouteCount);
            setLastStatusChange(model.lastStatusChange);
            setOutsideIpAddress(model.outsideIpAddress);
            setStatus(model.status);
            setStatusMessage(model.statusMessage);
        }

        public final Integer getAcceptedRouteCount() {
            return acceptedRouteCount;
        }

        @Override
        public final Builder acceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
            return this;
        }

        public final void setAcceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
        }

        public final Instant getLastStatusChange() {
            return lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getOutsideIpAddress() {
            return outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(TelemetryStatus status) {
            this.status(status.toString());
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public VgwTelemetry build() {
            return new VgwTelemetry(this);
        }
    }
}
