/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for UnassignPrivateIpAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnassignPrivateIpAddressesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UnassignPrivateIpAddressesRequest.Builder, UnassignPrivateIpAddressesRequest> {
    private final String networkInterfaceId;

    private final List<String> privateIpAddresses;

    private UnassignPrivateIpAddressesRequest(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The secondary private IP addresses to unassign from the network interface. You can specify this option multiple
     * times to unassign more than one IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The secondary private IP addresses to unassign from the network interface. You can specify this option
     *         multiple times to unassign more than one IP address.
     */
    public List<String> privateIpAddresses() {
        return privateIpAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddresses() == null) ? 0 : privateIpAddresses().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignPrivateIpAddressesRequest)) {
            return false;
        }
        UnassignPrivateIpAddressesRequest other = (UnassignPrivateIpAddressesRequest) obj;
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(privateIpAddresses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UnassignPrivateIpAddressesRequest> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The secondary private IP addresses to unassign from the network interface. You can specify this option
         * multiple times to unassign more than one IP address.
         * </p>
         * 
         * @param privateIpAddresses
         *        The secondary private IP addresses to unassign from the network interface. You can specify this option
         *        multiple times to unassign more than one IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<String> privateIpAddresses);

        /**
         * <p>
         * The secondary private IP addresses to unassign from the network interface. You can specify this option
         * multiple times to unassign more than one IP address.
         * </p>
         * 
         * @param privateIpAddresses
         *        The secondary private IP addresses to unassign from the network interface. You can specify this option
         *        multiple times to unassign more than one IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(String... privateIpAddresses);
    }

    private static final class BuilderImpl implements Builder {
        private String networkInterfaceId;

        private List<String> privateIpAddresses;

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignPrivateIpAddressesRequest model) {
            setNetworkInterfaceId(model.networkInterfaceId);
            setPrivateIpAddresses(model.privateIpAddresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @SafeVarargs
        public final void setPrivateIpAddresses(String... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
        }

        @Override
        public UnassignPrivateIpAddressesRequest build() {
            return new UnassignPrivateIpAddressesRequest(this);
        }
    }
}
