/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the snapshot created from the imported disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SnapshotDetail implements ToCopyableBuilder<SnapshotDetail.Builder, SnapshotDetail> {
    private final String description;

    private final String deviceName;

    private final Double diskImageSize;

    private final String format;

    private final String progress;

    private final String snapshotId;

    private final String status;

    private final String statusMessage;

    private final String url;

    private final UserBucketDetails userBucket;

    private SnapshotDetail(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.diskImageSize = builder.diskImageSize;
        this.format = builder.format;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The block device mapping for the snapshot.
     * </p>
     * 
     * @return The block device mapping for the snapshot.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The size of the disk in the snapshot, in GiB.
     * </p>
     * 
     * @return The size of the disk in the snapshot, in GiB.
     */
    public Double diskImageSize() {
        return diskImageSize;
    }

    /**
     * <p>
     * The format of the disk image from which the snapshot is created.
     * </p>
     * 
     * @return The format of the disk image from which the snapshot is created.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The percentage of progress for the task.
     * </p>
     * 
     * @return The percentage of progress for the task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The snapshot ID of the disk being imported.
     * </p>
     * 
     * @return The snapshot ID of the disk being imported.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * A brief status of the snapshot creation.
     * </p>
     * 
     * @return A brief status of the snapshot creation.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status message for the snapshot creation.
     * </p>
     * 
     * @return A detailed status message for the snapshot creation.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The URL used to access the disk image.
     * </p>
     * 
     * @return The URL used to access the disk image.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The S3 bucket for the disk image.
     * </p>
     * 
     * @return The S3 bucket for the disk image.
     */
    public UserBucketDetails userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((deviceName() == null) ? 0 : deviceName().hashCode());
        hashCode = 31 * hashCode + ((diskImageSize() == null) ? 0 : diskImageSize().hashCode());
        hashCode = 31 * hashCode + ((format() == null) ? 0 : format().hashCode());
        hashCode = 31 * hashCode + ((progress() == null) ? 0 : progress().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        hashCode = 31 * hashCode + ((url() == null) ? 0 : url().hashCode());
        hashCode = 31 * hashCode + ((userBucket() == null) ? 0 : userBucket().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetail)) {
            return false;
        }
        SnapshotDetail other = (SnapshotDetail) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.diskImageSize() == null ^ this.diskImageSize() == null) {
            return false;
        }
        if (other.diskImageSize() != null && !other.diskImageSize().equals(this.diskImageSize())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        if (other.userBucket() == null ^ this.userBucket() == null) {
            return false;
        }
        if (other.userBucket() != null && !other.userBucket().equals(this.userBucket())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (diskImageSize() != null) {
            sb.append("DiskImageSize: ").append(diskImageSize()).append(",");
        }
        if (format() != null) {
            sb.append("Format: ").append(format()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        if (userBucket() != null) {
            sb.append("UserBucket: ").append(userBucket()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SnapshotDetail> {
        /**
         * <p>
         * A description for the snapshot.
         * </p>
         * 
         * @param description
         *        A description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The block device mapping for the snapshot.
         * </p>
         * 
         * @param deviceName
         *        The block device mapping for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The size of the disk in the snapshot, in GiB.
         * </p>
         * 
         * @param diskImageSize
         *        The size of the disk in the snapshot, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImageSize(Double diskImageSize);

        /**
         * <p>
         * The format of the disk image from which the snapshot is created.
         * </p>
         * 
         * @param format
         *        The format of the disk image from which the snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The percentage of progress for the task.
         * </p>
         * 
         * @param progress
         *        The percentage of progress for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The snapshot ID of the disk being imported.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID of the disk being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * A brief status of the snapshot creation.
         * </p>
         * 
         * @param status
         *        A brief status of the snapshot creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status message for the snapshot creation.
         * </p>
         * 
         * @param statusMessage
         *        A detailed status message for the snapshot creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The URL used to access the disk image.
         * </p>
         * 
         * @param url
         *        The URL used to access the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucketDetails userBucket);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String deviceName;

        private Double diskImageSize;

        private String format;

        private String progress;

        private String snapshotId;

        private String status;

        private String statusMessage;

        private String url;

        private UserBucketDetails userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetail model) {
            setDescription(model.description);
            setDeviceName(model.deviceName);
            setDiskImageSize(model.diskImageSize);
            setFormat(model.format);
            setProgress(model.progress);
            setSnapshotId(model.snapshotId);
            setStatus(model.status);
            setStatusMessage(model.statusMessage);
            setUrl(model.url);
            setUserBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Double getDiskImageSize() {
            return diskImageSize;
        }

        @Override
        public final Builder diskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
            return this;
        }

        public final void setDiskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucketDetails getUserBucket() {
            return userBucket;
        }

        @Override
        public final Builder userBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
        }

        @Override
        public SnapshotDetail build() {
            return new SnapshotDetail(this);
        }
    }
}
