/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Snapshot implements ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private final String dataEncryptionKeyId;

    private final String description;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String ownerId;

    private final String progress;

    private final String snapshotId;

    private final Instant startTime;

    private final String state;

    private final String stateMessage;

    private final String volumeId;

    private final Integer volumeSize;

    private final String ownerAlias;

    private final List<Tag> tags;

    private Snapshot(BuilderImpl builder) {
        this.dataEncryptionKeyId = builder.dataEncryptionKeyId;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.ownerId = builder.ownerId;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.volumeId = builder.volumeId;
        this.volumeSize = builder.volumeSize;
        this.ownerAlias = builder.ownerAlias;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the
     * data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys
     * are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key
     * identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by the
     * <a>DescribeSnapshots</a> API operation.
     * </p>
     * 
     * @return The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds
     *         to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data
     *         encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the
     *         same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter
     *         is only returned by the <a>DescribeSnapshots</a> API operation.
     */
    public String dataEncryptionKeyId() {
        return dataEncryptionKeyId;
    }

    /**
     * <p>
     * The description for the snapshot.
     * </p>
     * 
     * @return The description for the snapshot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the snapshot is encrypted.
     * </p>
     * 
     * @return Indicates whether the snapshot is encrypted.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the
     * volume encryption key for the parent volume.
     * </p>
     * 
     * @return The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to
     *         protect the volume encryption key for the parent volume.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The AWS account ID of the EBS snapshot owner.
     * </p>
     * 
     * @return The AWS account ID of the EBS snapshot owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The progress of the snapshot, as a percentage.
     * </p>
     * 
     * @return The progress of the snapshot, as a percentage.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     * </p>
     * 
     * @return The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The time stamp when the snapshot was initiated.
     * </p>
     * 
     * @return The time stamp when the snapshot was initiated.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The snapshot state.
     * </p>
     * 
     * @return The snapshot state.
     * @see SnapshotState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the
     * proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field displays error state details
     * to help you diagnose why the error occurred. This parameter is only returned by the <a>DescribeSnapshots</a> API
     * operation.
     * </p>
     * 
     * @return Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for
     *         example, if the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field
     *         displays error state details to help you diagnose why the error occurred. This parameter is only returned
     *         by the <a>DescribeSnapshots</a> API operation.
     */
    public String stateMessage() {
        return stateMessage;
    }

    /**
     * <p>
     * The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a> action
     * have an arbitrary volume ID that should not be used for any purpose.
     * </p>
     * 
     * @return The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a>
     *         action have an arbitrary volume ID that should not be used for any purpose.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * Value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> | <code>microsoft</code>
     * ) of snapshot owners. Not to be confused with the user-configured AWS account alias, which is set from the IAM
     * console.
     * </p>
     * 
     * @return Value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> |
     *         <code>microsoft</code>) of snapshot owners. Not to be confused with the user-configured AWS account
     *         alias, which is set from the IAM console.
     */
    public String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * Any tags assigned to the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the snapshot.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataEncryptionKeyId() == null) ? 0 : dataEncryptionKeyId().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((encrypted() == null) ? 0 : encrypted().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyId() == null) ? 0 : kmsKeyId().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((progress() == null) ? 0 : progress().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((stateMessage() == null) ? 0 : stateMessage().hashCode());
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        hashCode = 31 * hashCode + ((volumeSize() == null) ? 0 : volumeSize().hashCode());
        hashCode = 31 * hashCode + ((ownerAlias() == null) ? 0 : ownerAlias().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        if (other.dataEncryptionKeyId() == null ^ this.dataEncryptionKeyId() == null) {
            return false;
        }
        if (other.dataEncryptionKeyId() != null && !other.dataEncryptionKeyId().equals(this.dataEncryptionKeyId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateMessage() == null ^ this.stateMessage() == null) {
            return false;
        }
        if (other.stateMessage() != null && !other.stateMessage().equals(this.stateMessage())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.volumeSize() == null ^ this.volumeSize() == null) {
            return false;
        }
        if (other.volumeSize() != null && !other.volumeSize().equals(this.volumeSize())) {
            return false;
        }
        if (other.ownerAlias() == null ^ this.ownerAlias() == null) {
            return false;
        }
        if (other.ownerAlias() != null && !other.ownerAlias().equals(this.ownerAlias())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dataEncryptionKeyId() != null) {
            sb.append("DataEncryptionKeyId: ").append(dataEncryptionKeyId()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (encrypted() != null) {
            sb.append("Encrypted: ").append(encrypted()).append(",");
        }
        if (kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(kmsKeyId()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (stateMessage() != null) {
            sb.append("StateMessage: ").append(stateMessage()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (volumeSize() != null) {
            sb.append("VolumeSize: ").append(volumeSize()).append(",");
        }
        if (ownerAlias() != null) {
            sb.append("OwnerAlias: ").append(ownerAlias()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Snapshot> {
        /**
         * <p>
         * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to
         * the data encryption key that was used to encrypt the original volume or snapshot copy. Because data
         * encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same
         * data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only
         * returned by the <a>DescribeSnapshots</a> API operation.
         * </p>
         * 
         * @param dataEncryptionKeyId
         *        The data encryption key identifier for the snapshot. This value is a unique identifier that
         *        corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy.
         *        Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if
         *        snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot
         *        lineage. This parameter is only returned by the <a>DescribeSnapshots</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEncryptionKeyId(String dataEncryptionKeyId);

        /**
         * <p>
         * The description for the snapshot.
         * </p>
         * 
         * @param description
         *        The description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect
         * the volume encryption key for the parent volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to
         *        protect the volume encryption key for the parent volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The AWS account ID of the EBS snapshot owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the EBS snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The progress of the snapshot, as a percentage.
         * </p>
         * 
         * @param progress
         *        The progress of the snapshot, as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The time stamp when the snapshot was initiated.
         * </p>
         * 
         * @param startTime
         *        The time stamp when the snapshot was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The snapshot state.
         * </p>
         * 
         * @param state
         *        The snapshot state.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The snapshot state.
         * </p>
         * 
         * @param state
         *        The snapshot state.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(SnapshotState state);

        /**
         * <p>
         * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if
         * the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field displays error state
         * details to help you diagnose why the error occurred. This parameter is only returned by the
         * <a>DescribeSnapshots</a> API operation.
         * </p>
         * 
         * @param stateMessage
         *        Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for
         *        example, if the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field
         *        displays error state details to help you diagnose why the error occurred. This parameter is only
         *        returned by the <a>DescribeSnapshots</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * <p>
         * The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a>
         * action have an arbitrary volume ID that should not be used for any purpose.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that was used to create the snapshot. Snapshots created by the
         *        <a>CopySnapshot</a> action have an arbitrary volume ID that should not be used for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * Value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> |
         * <code>microsoft</code>) of snapshot owners. Not to be confused with the user-configured AWS account alias,
         * which is set from the IAM console.
         * </p>
         * 
         * @param ownerAlias
         *        Value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> |
         *        <code>microsoft</code>) of snapshot owners. Not to be confused with the user-configured AWS account
         *        alias, which is set from the IAM console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String dataEncryptionKeyId;

        private String description;

        private Boolean encrypted;

        private String kmsKeyId;

        private String ownerId;

        private String progress;

        private String snapshotId;

        private Instant startTime;

        private String state;

        private String stateMessage;

        private String volumeId;

        private Integer volumeSize;

        private String ownerAlias;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            setDataEncryptionKeyId(model.dataEncryptionKeyId);
            setDescription(model.description);
            setEncrypted(model.encrypted);
            setKmsKeyId(model.kmsKeyId);
            setOwnerId(model.ownerId);
            setProgress(model.progress);
            setSnapshotId(model.snapshotId);
            setStartTime(model.startTime);
            setState(model.state);
            setStateMessage(model.stateMessage);
            setVolumeId(model.volumeId);
            setVolumeSize(model.volumeSize);
            setOwnerAlias(model.ownerAlias);
            setTags(model.tags);
        }

        public final String getDataEncryptionKeyId() {
            return dataEncryptionKeyId;
        }

        @Override
        public final Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
            return this;
        }

        public final void setDataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(SnapshotState state) {
            this.state(state.toString());
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }
    }
}
