/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for a Scheduled Instance.
 * </p>
 * <p>
 * If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet. You can specify the
 * subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesLaunchSpecification implements
        ToCopyableBuilder<ScheduledInstancesLaunchSpecification.Builder, ScheduledInstancesLaunchSpecification> {
    private final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final ScheduledInstancesIamInstanceProfile iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final ScheduledInstancesMonitoring monitoring;

    private final List<ScheduledInstancesNetworkInterface> networkInterfaces;

    private final ScheduledInstancesPlacement placement;

    private final String ramdiskId;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String userData;

    private ScheduledInstancesLaunchSpecification(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    /**
     * <p>
     * One or more block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries.
     */
    public List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
     *         This optimization isn't available with all instance types. Additional usage charges apply when using an
     *         EBS-optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public ScheduledInstancesIamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI).
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI).
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Enable or disable monitoring for the instances.
     * </p>
     * 
     * @return Enable or disable monitoring for the instances.
     */
    public ScheduledInstancesMonitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * One or more network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interfaces.
     */
    public List<ScheduledInstancesNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information.
     * </p>
     * 
     * @return The placement information.
     */
    public ScheduledInstancesPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instances.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instances.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The base64-encoded MIME user data.
     * </p>
     * 
     * @return The base64-encoded MIME user data.
     */
    public String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((iamInstanceProfile() == null) ? 0 : iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((monitoring() == null) ? 0 : monitoring().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaces() == null) ? 0 : networkInterfaces().hashCode());
        hashCode = 31 * hashCode + ((placement() == null) ? 0 : placement().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((securityGroupIds() == null) ? 0 : securityGroupIds().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesLaunchSpecification)) {
            return false;
        }
        ScheduledInstancesLaunchSpecification other = (ScheduledInstancesLaunchSpecification) obj;
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (monitoring() != null) {
            sb.append("Monitoring: ").append(monitoring()).append(",");
        }
        if (networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(networkInterfaces()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(securityGroupIds()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS-optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI).
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * 
         * @param monitoring
         *        Enable or disable monitoring for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(ScheduledInstancesMonitoring monitoring);

        /**
         * <p>
         * One or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces);

        /**
         * <p>
         * The placement information.
         * </p>
         * 
         * @param placement
         *        The placement information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(ScheduledInstancesPlacement placement);

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the subnet in which to launch the instances.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The base64-encoded MIME user data.
         * </p>
         * 
         * @param userData
         *        The base64-encoded MIME user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    private static final class BuilderImpl implements Builder {
        private List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;

        private Boolean ebsOptimized;

        private ScheduledInstancesIamInstanceProfile iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private ScheduledInstancesMonitoring monitoring;

        private List<ScheduledInstancesNetworkInterface> networkInterfaces;

        private ScheduledInstancesPlacement placement;

        private String ramdiskId;

        private List<String> securityGroupIds;

        private String subnetId;

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesLaunchSpecification model) {
            setBlockDeviceMappings(model.blockDeviceMappings);
            setEbsOptimized(model.ebsOptimized);
            setIamInstanceProfile(model.iamInstanceProfile);
            setImageId(model.imageId);
            setInstanceType(model.instanceType);
            setKernelId(model.kernelId);
            setKeyName(model.keyName);
            setMonitoring(model.monitoring);
            setNetworkInterfaces(model.networkInterfaces);
            setPlacement(model.placement);
            setRamdiskId(model.ramdiskId);
            setSecurityGroupIds(model.securityGroupIds);
            setSubnetId(model.subnetId);
            setUserData(model.userData);
        }

        public final Collection<ScheduledInstancesBlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final ScheduledInstancesIamInstanceProfile getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final ScheduledInstancesMonitoring getMonitoring() {
            return monitoring;
        }

        @Override
        public final Builder monitoring(ScheduledInstancesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(ScheduledInstancesMonitoring monitoring) {
            this.monitoring = monitoring;
        }

        public final Collection<ScheduledInstancesNetworkInterface> getNetworkInterfaces() {
            return networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copy(networkInterfaces);
        }

        @SafeVarargs
        public final void setNetworkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
        }

        public final ScheduledInstancesPlacement getPlacement() {
            return placement;
        }

        @Override
        public final Builder placement(ScheduledInstancesPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(ScheduledInstancesPlacement placement) {
            this.placement = placement;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public ScheduledInstancesLaunchSpecification build() {
            return new ScheduledInstancesLaunchSpecification(this);
        }
    }
}
