/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route in a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Route implements ToCopyableBuilder<Route.Builder, Route> {
    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String destinationPrefixListId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String natGatewayId;

    private final String networkInterfaceId;

    private final String origin;

    private final String state;

    private final String vpcPeeringConnectionId;

    private Route(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.state = builder.state;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The IPv4 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv4 CIDR block used for the destination match.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv6 CIDR block used for the destination match.
     */
    public String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * The prefix of the AWS service.
     * </p>
     * 
     * @return The prefix of the AWS service.
     */
    public String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of the egress-only Internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only Internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of a gateway attached to your VPC.
     * </p>
     * 
     * @return The ID of a gateway attached to your VPC.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a NAT instance in your VPC.
     * </p>
     * 
     * @return The ID of a NAT instance in your VPC.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the instance.
     * </p>
     * 
     * @return The AWS account ID of the owner of the instance.
     */
    public String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The ID of a NAT gateway.
     * </p>
     * 
     * @return The ID of a NAT gateway.
     */
    public String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Describes how the route was created.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateRoute</code> - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes how the route was created.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateRoute</code> - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     *         </p>
     *         </li>
     * @see RouteOrigin
     */
    public String origin() {
        return origin;
    }

    /**
     * <p>
     * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available (for
     * example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
     * </p>
     * 
     * @return The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
     *         available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
     *         has been terminated).
     * @see RouteState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationCidrBlock() == null) ? 0 : destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + ((destinationIpv6CidrBlock() == null) ? 0 : destinationIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((destinationPrefixListId() == null) ? 0 : destinationPrefixListId().hashCode());
        hashCode = 31 * hashCode + ((egressOnlyInternetGatewayId() == null) ? 0 : egressOnlyInternetGatewayId().hashCode());
        hashCode = 31 * hashCode + ((gatewayId() == null) ? 0 : gatewayId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((instanceOwnerId() == null) ? 0 : instanceOwnerId().hashCode());
        hashCode = 31 * hashCode + ((natGatewayId() == null) ? 0 : natGatewayId().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((origin() == null) ? 0 : origin().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route) obj;
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.destinationIpv6CidrBlock() == null ^ this.destinationIpv6CidrBlock() == null) {
            return false;
        }
        if (other.destinationIpv6CidrBlock() != null && !other.destinationIpv6CidrBlock().equals(this.destinationIpv6CidrBlock())) {
            return false;
        }
        if (other.destinationPrefixListId() == null ^ this.destinationPrefixListId() == null) {
            return false;
        }
        if (other.destinationPrefixListId() != null && !other.destinationPrefixListId().equals(this.destinationPrefixListId())) {
            return false;
        }
        if (other.egressOnlyInternetGatewayId() == null ^ this.egressOnlyInternetGatewayId() == null) {
            return false;
        }
        if (other.egressOnlyInternetGatewayId() != null
                && !other.egressOnlyInternetGatewayId().equals(this.egressOnlyInternetGatewayId())) {
            return false;
        }
        if (other.gatewayId() == null ^ this.gatewayId() == null) {
            return false;
        }
        if (other.gatewayId() != null && !other.gatewayId().equals(this.gatewayId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceOwnerId() == null ^ this.instanceOwnerId() == null) {
            return false;
        }
        if (other.instanceOwnerId() != null && !other.instanceOwnerId().equals(this.instanceOwnerId())) {
            return false;
        }
        if (other.natGatewayId() == null ^ this.natGatewayId() == null) {
            return false;
        }
        if (other.natGatewayId() != null && !other.natGatewayId().equals(this.natGatewayId())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.origin() == null ^ this.origin() == null) {
            return false;
        }
        if (other.origin() != null && !other.origin().equals(this.origin())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(destinationCidrBlock()).append(",");
        }
        if (destinationIpv6CidrBlock() != null) {
            sb.append("DestinationIpv6CidrBlock: ").append(destinationIpv6CidrBlock()).append(",");
        }
        if (destinationPrefixListId() != null) {
            sb.append("DestinationPrefixListId: ").append(destinationPrefixListId()).append(",");
        }
        if (egressOnlyInternetGatewayId() != null) {
            sb.append("EgressOnlyInternetGatewayId: ").append(egressOnlyInternetGatewayId()).append(",");
        }
        if (gatewayId() != null) {
            sb.append("GatewayId: ").append(gatewayId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceOwnerId() != null) {
            sb.append("InstanceOwnerId: ").append(instanceOwnerId()).append(",");
        }
        if (natGatewayId() != null) {
            sb.append("NatGatewayId: ").append(natGatewayId()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (origin() != null) {
            sb.append("Origin: ").append(origin()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Route> {
        /**
         * <p>
         * The IPv4 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * The prefix of the AWS service.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The prefix of the AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of the egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of a gateway attached to your VPC.
         * </p>
         * 
         * @param gatewayId
         *        The ID of a gateway attached to your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a NAT instance in your VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of a NAT instance in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The AWS account ID of the owner of the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The AWS account ID of the owner of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @see RouteOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteOrigin
         */
        Builder origin(String origin);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @see RouteOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteOrigin
         */
        Builder origin(RouteOrigin origin);

        /**
         * <p>
         * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available
         * (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been
         * terminated).
         * </p>
         * 
         * @param state
         *        The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
         *        available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
         *        has been terminated).
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available
         * (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been
         * terminated).
         * </p>
         * 
         * @param state
         *        The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
         *        available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
         *        has been terminated).
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(RouteState state);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String destinationPrefixListId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String instanceOwnerId;

        private String natGatewayId;

        private String networkInterfaceId;

        private String origin;

        private String state;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            setDestinationCidrBlock(model.destinationCidrBlock);
            setDestinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            setDestinationPrefixListId(model.destinationPrefixListId);
            setEgressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            setGatewayId(model.gatewayId);
            setInstanceId(model.instanceId);
            setInstanceOwnerId(model.instanceOwnerId);
            setNatGatewayId(model.natGatewayId);
            setNetworkInterfaceId(model.networkInterfaceId);
            setOrigin(model.origin);
            setState(model.state);
            setVpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(RouteOrigin origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final void setOrigin(RouteOrigin origin) {
            this.origin(origin.toString());
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(RouteState state) {
            this.state(state.toString());
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Route build() {
            return new Route(this);
        }
    }
}
