/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RestoreAddressToClassic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RestoreAddressToClassicResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RestoreAddressToClassicResponse.Builder, RestoreAddressToClassicResponse> {
    private final String publicIp;

    private final String status;

    private RestoreAddressToClassicResponse(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The move status for the IP address.
     * </p>
     * 
     * @return The move status for the IP address.
     * @see Status
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreAddressToClassicResponse)) {
            return false;
        }
        RestoreAddressToClassicResponse other = (RestoreAddressToClassicResponse) obj;
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RestoreAddressToClassicResponse> {
        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The move status for the IP address.
         * </p>
         * 
         * @param status
         *        The move status for the IP address.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The move status for the IP address.
         * </p>
         * 
         * @param status
         *        The move status for the IP address.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    private static final class BuilderImpl implements Builder {
        private String publicIp;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreAddressToClassicResponse model) {
            setPublicIp(model.publicIp);
            setStatus(model.status);
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(Status status) {
            this.status(status.toString());
        }

        @Override
        public RestoreAddressToClassicResponse build() {
            return new RestoreAddressToClassicResponse(this);
        }
    }
}
