/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the modification request/s.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesModificationResult implements
        ToCopyableBuilder<ReservedInstancesModificationResult.Builder, ReservedInstancesModificationResult> {
    private final String reservedInstancesId;

    private final ReservedInstancesConfiguration targetConfiguration;

    private ReservedInstancesModificationResult(BuilderImpl builder) {
        this.reservedInstancesId = builder.reservedInstancesId;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * The ID for the Reserved Instances that were created as part of the modification request. This field is only
     * available when the modification is fulfilled.
     * </p>
     * 
     * @return The ID for the Reserved Instances that were created as part of the modification request. This field is
     *         only available when the modification is fulfilled.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The target Reserved Instances configurations supplied as part of the modification request.
     * </p>
     * 
     * @return The target Reserved Instances configurations supplied as part of the modification request.
     */
    public ReservedInstancesConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservedInstancesId() == null) ? 0 : reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + ((targetConfiguration() == null) ? 0 : targetConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModificationResult)) {
            return false;
        }
        ReservedInstancesModificationResult other = (ReservedInstancesModificationResult) obj;
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.targetConfiguration() == null ^ this.targetConfiguration() == null) {
            return false;
        }
        if (other.targetConfiguration() != null && !other.targetConfiguration().equals(this.targetConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(reservedInstancesId()).append(",");
        }
        if (targetConfiguration() != null) {
            sb.append("TargetConfiguration: ").append(targetConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesModificationResult> {
        /**
         * <p>
         * The ID for the Reserved Instances that were created as part of the modification request. This field is only
         * available when the modification is fulfilled.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID for the Reserved Instances that were created as part of the modification request. This field is
         *        only available when the modification is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The target Reserved Instances configurations supplied as part of the modification request.
         * </p>
         * 
         * @param targetConfiguration
         *        The target Reserved Instances configurations supplied as part of the modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String reservedInstancesId;

        private ReservedInstancesConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModificationResult model) {
            setReservedInstancesId(model.reservedInstancesId);
            setTargetConfiguration(model.targetConfiguration);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final ReservedInstancesConfiguration getTargetConfiguration() {
            return targetConfiguration;
        }

        @Override
        public final Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(ReservedInstancesConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
        }

        @Override
        public ReservedInstancesModificationResult build() {
            return new ReservedInstancesModificationResult(this);
        }
    }
}
