/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance listing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesListing implements ToCopyableBuilder<ReservedInstancesListing.Builder, ReservedInstancesListing> {
    private final String clientToken;

    private final Instant createDate;

    private final List<InstanceCount> instanceCounts;

    private final List<PriceSchedule> priceSchedules;

    private final String reservedInstancesId;

    private final String reservedInstancesListingId;

    private final String status;

    private final String statusMessage;

    private final List<Tag> tags;

    private final Instant updateDate;

    private ReservedInstancesListing(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.instanceCounts = builder.instanceCounts;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time the listing was created.
     * </p>
     * 
     * @return The time the listing was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The number of instances in this state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of instances in this state.
     */
    public List<InstanceCount> instanceCounts() {
        return instanceCounts;
    }

    /**
     * <p>
     * The price of the Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The price of the Reserved Instance listing.
     */
    public List<PriceSchedule> priceSchedules() {
        return priceSchedules;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance listing.
     * </p>
     * 
     * @return The ID of the Reserved Instance listing.
     */
    public String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    /**
     * <p>
     * The status of the Reserved Instance listing.
     * </p>
     * 
     * @return The status of the Reserved Instance listing.
     * @see ListingStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the Reserved Instance listing. The response can be blank.
     * </p>
     * 
     * @return The reason for the current status of the Reserved Instance listing. The response can be blank.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The last modified timestamp of the listing.
     * </p>
     * 
     * @return The last modified timestamp of the listing.
     */
    public Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((createDate() == null) ? 0 : createDate().hashCode());
        hashCode = 31 * hashCode + ((instanceCounts() == null) ? 0 : instanceCounts().hashCode());
        hashCode = 31 * hashCode + ((priceSchedules() == null) ? 0 : priceSchedules().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesId() == null) ? 0 : reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesListingId() == null) ? 0 : reservedInstancesListingId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((updateDate() == null) ? 0 : updateDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing) obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.instanceCounts() == null ^ this.instanceCounts() == null) {
            return false;
        }
        if (other.instanceCounts() != null && !other.instanceCounts().equals(this.instanceCounts())) {
            return false;
        }
        if (other.priceSchedules() == null ^ this.priceSchedules() == null) {
            return false;
        }
        if (other.priceSchedules() != null && !other.priceSchedules().equals(this.priceSchedules())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.reservedInstancesListingId() == null ^ this.reservedInstancesListingId() == null) {
            return false;
        }
        if (other.reservedInstancesListingId() != null
                && !other.reservedInstancesListingId().equals(this.reservedInstancesListingId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.updateDate() == null ^ this.updateDate() == null) {
            return false;
        }
        if (other.updateDate() != null && !other.updateDate().equals(this.updateDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (createDate() != null) {
            sb.append("CreateDate: ").append(createDate()).append(",");
        }
        if (instanceCounts() != null) {
            sb.append("InstanceCounts: ").append(instanceCounts()).append(",");
        }
        if (priceSchedules() != null) {
            sb.append("PriceSchedules: ").append(priceSchedules()).append(",");
        }
        if (reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(reservedInstancesId()).append(",");
        }
        if (reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(reservedInstancesListingId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (updateDate() != null) {
            sb.append("UpdateDate: ").append(updateDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesListing> {
        /**
         * <p>
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time the listing was created.
         * </p>
         * 
         * @param createDate
         *        The time the listing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * 
         * @param instanceCounts
         *        The number of instances in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(Collection<InstanceCount> instanceCounts);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * 
         * @param instanceCounts
         *        The number of instances in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(InstanceCount... instanceCounts);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * 
         * @param priceSchedules
         *        The price of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(Collection<PriceSchedule> priceSchedules);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * 
         * @param priceSchedules
         *        The price of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(PriceSchedule... priceSchedules);

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The ID of the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        The ID of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);

        /**
         * <p>
         * The status of the Reserved Instance listing.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instance listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Reserved Instance listing.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instance listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(ListingStatus status);

        /**
         * <p>
         * The reason for the current status of the Reserved Instance listing. The response can be blank.
         * </p>
         * 
         * @param statusMessage
         *        The reason for the current status of the Reserved Instance listing. The response can be blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The last modified timestamp of the listing.
         * </p>
         * 
         * @param updateDate
         *        The last modified timestamp of the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    private static final class BuilderImpl implements Builder {
        private String clientToken;

        private Instant createDate;

        private List<InstanceCount> instanceCounts;

        private List<PriceSchedule> priceSchedules;

        private String reservedInstancesId;

        private String reservedInstancesListingId;

        private String status;

        private String statusMessage;

        private List<Tag> tags;

        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesListing model) {
            setClientToken(model.clientToken);
            setCreateDate(model.createDate);
            setInstanceCounts(model.instanceCounts);
            setPriceSchedules(model.priceSchedules);
            setReservedInstancesId(model.reservedInstancesId);
            setReservedInstancesListingId(model.reservedInstancesListingId);
            setStatus(model.status);
            setStatusMessage(model.statusMessage);
            setTags(model.tags);
            setUpdateDate(model.updateDate);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<InstanceCount> getInstanceCounts() {
            return instanceCounts;
        }

        @Override
        public final Builder instanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(InstanceCount... instanceCounts) {
            instanceCounts(Arrays.asList(instanceCounts));
            return this;
        }

        public final void setInstanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
        }

        @SafeVarargs
        public final void setInstanceCounts(InstanceCount... instanceCounts) {
            instanceCounts(Arrays.asList(instanceCounts));
        }

        public final Collection<PriceSchedule> getPriceSchedules() {
            return priceSchedules;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceSchedule... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
        }

        @SafeVarargs
        public final void setPriceSchedules(PriceSchedule... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ListingStatus status) {
            this.status(status.toString());
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public ReservedInstancesListing build() {
            return new ReservedInstancesListing(this);
        }
    }
}
