/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the limit price of a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstanceLimitPrice implements
        ToCopyableBuilder<ReservedInstanceLimitPrice.Builder, ReservedInstanceLimitPrice> {
    private final Double amount;

    private final String currencyCode;

    private ReservedInstanceLimitPrice(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount *
     * price).
     * </p>
     * 
     * @return Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order
     *         (instanceCount * price).
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported currency
     * is <code>USD</code>.
     * </p>
     * 
     * @return The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
     *         currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCode() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((amount() == null) ? 0 : amount().hashCode());
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceLimitPrice)) {
            return false;
        }
        ReservedInstanceLimitPrice other = (ReservedInstanceLimitPrice) obj;
        if (other.amount() == null ^ this.amount() == null) {
            return false;
        }
        if (other.amount() != null && !other.amount().equals(this.amount())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (amount() != null) {
            sb.append("Amount: ").append(amount()).append(",");
        }
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstanceLimitPrice> {
        /**
         * <p>
         * Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount
         * * price).
         * </p>
         * 
         * @param amount
         *        Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order
         *        (instanceCount * price).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
         * currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>limitPrice</code> amount is specified. At this time, the only
         *        supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
         * currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>limitPrice</code> amount is specified. At this time, the only
         *        supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);
    }

    private static final class BuilderImpl implements Builder {
        private Double amount;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceLimitPrice model) {
            setAmount(model.amount);
            setCurrencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        @Override
        public ReservedInstanceLimitPrice build() {
            return new ReservedInstanceLimitPrice(this);
        }
    }
}
