/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of PurchaseScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseScheduledInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PurchaseScheduledInstancesResponse.Builder, PurchaseScheduledInstancesResponse> {
    private final List<ScheduledInstance> scheduledInstanceSet;

    private PurchaseScheduledInstancesResponse(BuilderImpl builder) {
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    /**
     * <p>
     * Information about the Scheduled Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Scheduled Instances.
     */
    public List<ScheduledInstance> scheduledInstanceSet() {
        return scheduledInstanceSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((scheduledInstanceSet() == null) ? 0 : scheduledInstanceSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesResponse)) {
            return false;
        }
        PurchaseScheduledInstancesResponse other = (PurchaseScheduledInstancesResponse) obj;
        if (other.scheduledInstanceSet() == null ^ this.scheduledInstanceSet() == null) {
            return false;
        }
        if (other.scheduledInstanceSet() != null && !other.scheduledInstanceSet().equals(this.scheduledInstanceSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (scheduledInstanceSet() != null) {
            sb.append("ScheduledInstanceSet: ").append(scheduledInstanceSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseScheduledInstancesResponse> {
        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceSet
         *        Information about the Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet);

        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceSet
         *        Information about the Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceSet(ScheduledInstance... scheduledInstanceSet);
    }

    private static final class BuilderImpl implements Builder {
        private List<ScheduledInstance> scheduledInstanceSet;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesResponse model) {
            setScheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final Collection<ScheduledInstance> getScheduledInstanceSet() {
            return scheduledInstanceSet;
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = PurchasedScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance... scheduledInstanceSet) {
            scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = PurchasedScheduledInstanceSetCopier.copy(scheduledInstanceSet);
        }

        @SafeVarargs
        public final void setScheduledInstanceSet(ScheduledInstance... scheduledInstanceSet) {
            scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
        }

        @Override
        public PurchaseScheduledInstancesResponse build() {
            return new PurchaseScheduledInstancesResponse(this);
        }
    }
}
