/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a product code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProductCode implements ToCopyableBuilder<ProductCode.Builder, ProductCode> {
    private final String productCodeId;

    private final String productCodeType;

    private ProductCode(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeType = builder.productCodeType;
    }

    /**
     * <p>
     * The product code.
     * </p>
     * 
     * @return The product code.
     */
    public String productCodeId() {
        return productCodeId;
    }

    /**
     * <p>
     * The type of product code.
     * </p>
     * 
     * @return The type of product code.
     * @see ProductCodeValues
     */
    public String productCodeType() {
        return productCodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((productCodeId() == null) ? 0 : productCodeId().hashCode());
        hashCode = 31 * hashCode + ((productCodeType() == null) ? 0 : productCodeType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode) obj;
        if (other.productCodeId() == null ^ this.productCodeId() == null) {
            return false;
        }
        if (other.productCodeId() != null && !other.productCodeId().equals(this.productCodeId())) {
            return false;
        }
        if (other.productCodeType() == null ^ this.productCodeType() == null) {
            return false;
        }
        if (other.productCodeType() != null && !other.productCodeType().equals(this.productCodeType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (productCodeId() != null) {
            sb.append("ProductCodeId: ").append(productCodeId()).append(",");
        }
        if (productCodeType() != null) {
            sb.append("ProductCodeType: ").append(productCodeType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ProductCode> {
        /**
         * <p>
         * The product code.
         * </p>
         * 
         * @param productCodeId
         *        The product code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodeId(String productCodeId);

        /**
         * <p>
         * The type of product code.
         * </p>
         * 
         * @param productCodeType
         *        The type of product code.
         * @see ProductCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeValues
         */
        Builder productCodeType(String productCodeType);

        /**
         * <p>
         * The type of product code.
         * </p>
         * 
         * @param productCodeType
         *        The type of product code.
         * @see ProductCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeValues
         */
        Builder productCodeType(ProductCodeValues productCodeType);
    }

    private static final class BuilderImpl implements Builder {
        private String productCodeId;

        private String productCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            setProductCodeId(model.productCodeId);
            setProductCodeType(model.productCodeType);
        }

        public final String getProductCodeId() {
            return productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        public final String getProductCodeType() {
            return productCodeType;
        }

        @Override
        public final Builder productCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
            return this;
        }

        @Override
        public final Builder productCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType.toString());
            return this;
        }

        public final void setProductCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
        }

        public final void setProductCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType.toString());
        }

        @Override
        public ProductCode build() {
            return new ProductCode(this);
        }
    }
}
