/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ID of the prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PrefixListId implements ToCopyableBuilder<PrefixListId.Builder, PrefixListId> {
    private final String prefixListId;

    private PrefixListId(BuilderImpl builder) {
        this.prefixListId = builder.prefixListId;
    }

    /**
     * <p>
     * The ID of the prefix.
     * </p>
     * 
     * @return The ID of the prefix.
     */
    public String prefixListId() {
        return prefixListId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((prefixListId() == null) ? 0 : prefixListId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixListId)) {
            return false;
        }
        PrefixListId other = (PrefixListId) obj;
        if (other.prefixListId() == null ^ this.prefixListId() == null) {
            return false;
        }
        if (other.prefixListId() != null && !other.prefixListId().equals(this.prefixListId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (prefixListId() != null) {
            sb.append("PrefixListId: ").append(prefixListId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PrefixListId> {
        /**
         * <p>
         * The ID of the prefix.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);
    }

    private static final class BuilderImpl implements Builder {
        private String prefixListId;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixListId model) {
            setPrefixListId(model.prefixListId);
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public PrefixListId build() {
            return new PrefixListId(this);
        }
    }
}
