/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the VPC peering connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PeeringConnectionOptions implements ToCopyableBuilder<PeeringConnectionOptions.Builder, PeeringConnectionOptions> {
    private final Boolean allowDnsResolutionFromRemoteVpc;

    private final Boolean allowEgressFromLocalClassicLinkToRemoteVpc;

    private final Boolean allowEgressFromLocalVpcToRemoteClassicLink;

    private PeeringConnectionOptions(BuilderImpl builder) {
        this.allowDnsResolutionFromRemoteVpc = builder.allowDnsResolutionFromRemoteVpc;
        this.allowEgressFromLocalClassicLinkToRemoteVpc = builder.allowEgressFromLocalClassicLinkToRemoteVpc;
        this.allowEgressFromLocalVpcToRemoteClassicLink = builder.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    /**
     * <p>
     * If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances
     * in the peer VPC.
     * </p>
     * 
     * @return If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from
     *         instances in the peer VPC.
     */
    public Boolean allowDnsResolutionFromRemoteVpc() {
        return allowDnsResolutionFromRemoteVpc;
    }

    /**
     * <p>
     * If true, enables outbound communication from an EC2-Classic instance that's linked to a local VPC via ClassicLink
     * to instances in a peer VPC.
     * </p>
     * 
     * @return If true, enables outbound communication from an EC2-Classic instance that's linked to a local VPC via
     *         ClassicLink to instances in a peer VPC.
     */
    public Boolean allowEgressFromLocalClassicLinkToRemoteVpc() {
        return allowEgressFromLocalClassicLinkToRemoteVpc;
    }

    /**
     * <p>
     * If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that's linked to
     * a peer VPC via ClassicLink.
     * </p>
     * 
     * @return If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that's
     *         linked to a peer VPC via ClassicLink.
     */
    public Boolean allowEgressFromLocalVpcToRemoteClassicLink() {
        return allowEgressFromLocalVpcToRemoteClassicLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((allowDnsResolutionFromRemoteVpc() == null) ? 0 : allowDnsResolutionFromRemoteVpc().hashCode());
        hashCode = 31
                * hashCode
                + ((allowEgressFromLocalClassicLinkToRemoteVpc() == null) ? 0 : allowEgressFromLocalClassicLinkToRemoteVpc()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((allowEgressFromLocalVpcToRemoteClassicLink() == null) ? 0 : allowEgressFromLocalVpcToRemoteClassicLink()
                        .hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeeringConnectionOptions)) {
            return false;
        }
        PeeringConnectionOptions other = (PeeringConnectionOptions) obj;
        if (other.allowDnsResolutionFromRemoteVpc() == null ^ this.allowDnsResolutionFromRemoteVpc() == null) {
            return false;
        }
        if (other.allowDnsResolutionFromRemoteVpc() != null
                && !other.allowDnsResolutionFromRemoteVpc().equals(this.allowDnsResolutionFromRemoteVpc())) {
            return false;
        }
        if (other.allowEgressFromLocalClassicLinkToRemoteVpc() == null
                ^ this.allowEgressFromLocalClassicLinkToRemoteVpc() == null) {
            return false;
        }
        if (other.allowEgressFromLocalClassicLinkToRemoteVpc() != null
                && !other.allowEgressFromLocalClassicLinkToRemoteVpc().equals(this.allowEgressFromLocalClassicLinkToRemoteVpc())) {
            return false;
        }
        if (other.allowEgressFromLocalVpcToRemoteClassicLink() == null
                ^ this.allowEgressFromLocalVpcToRemoteClassicLink() == null) {
            return false;
        }
        if (other.allowEgressFromLocalVpcToRemoteClassicLink() != null
                && !other.allowEgressFromLocalVpcToRemoteClassicLink().equals(this.allowEgressFromLocalVpcToRemoteClassicLink())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (allowDnsResolutionFromRemoteVpc() != null) {
            sb.append("AllowDnsResolutionFromRemoteVpc: ").append(allowDnsResolutionFromRemoteVpc()).append(",");
        }
        if (allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
            sb.append("AllowEgressFromLocalClassicLinkToRemoteVpc: ").append(allowEgressFromLocalClassicLinkToRemoteVpc())
                    .append(",");
        }
        if (allowEgressFromLocalVpcToRemoteClassicLink() != null) {
            sb.append("AllowEgressFromLocalVpcToRemoteClassicLink: ").append(allowEgressFromLocalVpcToRemoteClassicLink())
                    .append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PeeringConnectionOptions> {
        /**
         * <p>
         * If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from
         * instances in the peer VPC.
         * </p>
         * 
         * @param allowDnsResolutionFromRemoteVpc
         *        If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from
         *        instances in the peer VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc);

        /**
         * <p>
         * If true, enables outbound communication from an EC2-Classic instance that's linked to a local VPC via
         * ClassicLink to instances in a peer VPC.
         * </p>
         * 
         * @param allowEgressFromLocalClassicLinkToRemoteVpc
         *        If true, enables outbound communication from an EC2-Classic instance that's linked to a local VPC via
         *        ClassicLink to instances in a peer VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc);

        /**
         * <p>
         * If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that's
         * linked to a peer VPC via ClassicLink.
         * </p>
         * 
         * @param allowEgressFromLocalVpcToRemoteClassicLink
         *        If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance
         *        that's linked to a peer VPC via ClassicLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean allowDnsResolutionFromRemoteVpc;

        private Boolean allowEgressFromLocalClassicLinkToRemoteVpc;

        private Boolean allowEgressFromLocalVpcToRemoteClassicLink;

        private BuilderImpl() {
        }

        private BuilderImpl(PeeringConnectionOptions model) {
            setAllowDnsResolutionFromRemoteVpc(model.allowDnsResolutionFromRemoteVpc);
            setAllowEgressFromLocalClassicLinkToRemoteVpc(model.allowEgressFromLocalClassicLinkToRemoteVpc);
            setAllowEgressFromLocalVpcToRemoteClassicLink(model.allowEgressFromLocalVpcToRemoteClassicLink);
        }

        public final Boolean getAllowDnsResolutionFromRemoteVpc() {
            return allowDnsResolutionFromRemoteVpc;
        }

        @Override
        public final Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
            return this;
        }

        public final void setAllowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalClassicLinkToRemoteVpc() {
            return allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        @Override
        public final Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
            return this;
        }

        public final void setAllowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalVpcToRemoteClassicLink() {
            return allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public final Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
            return this;
        }

        public final void setAllowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public PeeringConnectionOptions build() {
            return new PeeringConnectionOptions(this);
        }
    }
}
