/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterface implements ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private final NetworkInterfaceAssociation association;

    private final NetworkInterfaceAttachment attachment;

    private final String availabilityZone;

    private final String description;

    private final List<GroupIdentifier> groups;

    private final String interfaceType;

    private final List<NetworkInterfaceIpv6Address> ipv6Addresses;

    private final String macAddress;

    private final String networkInterfaceId;

    private final String ownerId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<NetworkInterfacePrivateIpAddress> privateIpAddresses;

    private final String requesterId;

    private final Boolean requesterManaged;

    private final Boolean sourceDestCheck;

    private final String status;

    private final String subnetId;

    private final List<Tag> tagSet;

    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.requesterId = builder.requesterId;
        this.requesterManaged = builder.requesterManaged;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tagSet = builder.tagSet;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public NetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * The network interface attachment.
     * </p>
     * 
     * @return The network interface attachment.
     */
    public NetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A description.
     * </p>
     * 
     * @return A description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Any security groups for the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any security groups for the network interface.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * The type of interface.
     * </p>
     * 
     * @return The type of interface.
     * @see NetworkInterfaceType
     */
    public String interfaceType() {
        return interfaceType;
    }

    /**
     * <p>
     * The IPv6 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 addresses associated with the network interface.
     */
    public List<NetworkInterfaceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The MAC address.
     * </p>
     * 
     * @return The MAC address.
     */
    public String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the network interface.
     * </p>
     * 
     * @return The AWS account ID of the owner of the network interface.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The private IPv4 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The private IPv4 addresses associated with the network interface.
     */
    public List<NetworkInterfacePrivateIpAddress> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or Auto
     * Scaling).
     * </p>
     * 
     * @return The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or
     *         Auto Scaling).
     */
    public String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * Indicates whether the network interface is being managed by AWS.
     * </p>
     * 
     * @return Indicates whether the network interface is being managed by AWS.
     */
    public Boolean requesterManaged() {
        return requesterManaged;
    }

    /**
     * <p>
     * Indicates whether traffic to or from the instance is validated.
     * </p>
     * 
     * @return Indicates whether traffic to or from the instance is validated.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Any tags assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the network interface.
     */
    public List<Tag> tagSet() {
        return tagSet;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((association() == null) ? 0 : association().hashCode());
        hashCode = 31 * hashCode + ((attachment() == null) ? 0 : attachment().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((interfaceType() == null) ? 0 : interfaceType().hashCode());
        hashCode = 31 * hashCode + ((ipv6Addresses() == null) ? 0 : ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + ((macAddress() == null) ? 0 : macAddress().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((privateDnsName() == null) ? 0 : privateDnsName().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddresses() == null) ? 0 : privateIpAddresses().hashCode());
        hashCode = 31 * hashCode + ((requesterId() == null) ? 0 : requesterId().hashCode());
        hashCode = 31 * hashCode + ((requesterManaged() == null) ? 0 : requesterManaged().hashCode());
        hashCode = 31 * hashCode + ((sourceDestCheck() == null) ? 0 : sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((tagSet() == null) ? 0 : tagSet().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        if (other.association() == null ^ this.association() == null) {
            return false;
        }
        if (other.association() != null && !other.association().equals(this.association())) {
            return false;
        }
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.interfaceType() == null ^ this.interfaceType() == null) {
            return false;
        }
        if (other.interfaceType() != null && !other.interfaceType().equals(this.interfaceType())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.macAddress() == null ^ this.macAddress() == null) {
            return false;
        }
        if (other.macAddress() != null && !other.macAddress().equals(this.macAddress())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        if (other.requesterId() == null ^ this.requesterId() == null) {
            return false;
        }
        if (other.requesterId() != null && !other.requesterId().equals(this.requesterId())) {
            return false;
        }
        if (other.requesterManaged() == null ^ this.requesterManaged() == null) {
            return false;
        }
        if (other.requesterManaged() != null && !other.requesterManaged().equals(this.requesterManaged())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.tagSet() == null ^ this.tagSet() == null) {
            return false;
        }
        if (other.tagSet() != null && !other.tagSet().equals(this.tagSet())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (association() != null) {
            sb.append("Association: ").append(association()).append(",");
        }
        if (attachment() != null) {
            sb.append("Attachment: ").append(attachment()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (interfaceType() != null) {
            sb.append("InterfaceType: ").append(interfaceType()).append(",");
        }
        if (ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(ipv6Addresses()).append(",");
        }
        if (macAddress() != null) {
            sb.append("MacAddress: ").append(macAddress()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(privateIpAddresses()).append(",");
        }
        if (requesterId() != null) {
            sb.append("RequesterId: ").append(requesterId()).append(",");
        }
        if (requesterManaged() != null) {
            sb.append("RequesterManaged: ").append(requesterManaged()).append(",");
        }
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (tagSet() != null) {
            sb.append("TagSet: ").append(tagSet()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IP address (IPv4) associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(NetworkInterfaceAssociation association);

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * 
         * @param attachment
         *        The network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(NetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A description.
         * </p>
         * 
         * @param description
         *        A description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * 
         * @param groups
         *        Any security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * 
         * @param groups
         *        Any security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * The type of interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The type of interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder interfaceType(NetworkInterfaceType interfaceType);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The MAC address.
         * </p>
         * 
         * @param macAddress
         *        The MAC address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The AWS account ID of the owner of the network interface.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the owner of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses);

        /**
         * <p>
         * The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or Auto
         * Scaling).
         * </p>
         * 
         * @param requesterId
         *        The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or
         *        Auto Scaling).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * Indicates whether the network interface is being managed by AWS.
         * </p>
         * 
         * @param requesterManaged
         *        Indicates whether the network interface is being managed by AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterManaged(Boolean requesterManaged);

        /**
         * <p>
         * Indicates whether traffic to or from the instance is validated.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether traffic to or from the instance is validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(NetworkInterfaceStatus status);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * 
         * @param tagSet
         *        Any tags assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Collection<Tag> tagSet);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * 
         * @param tagSet
         *        Any tags assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Tag... tagSet);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private NetworkInterfaceAssociation association;

        private NetworkInterfaceAttachment attachment;

        private String availabilityZone;

        private String description;

        private List<GroupIdentifier> groups;

        private String interfaceType;

        private List<NetworkInterfaceIpv6Address> ipv6Addresses;

        private String macAddress;

        private String networkInterfaceId;

        private String ownerId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<NetworkInterfacePrivateIpAddress> privateIpAddresses;

        private String requesterId;

        private Boolean requesterManaged;

        private Boolean sourceDestCheck;

        private String status;

        private String subnetId;

        private List<Tag> tagSet;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            setAssociation(model.association);
            setAttachment(model.attachment);
            setAvailabilityZone(model.availabilityZone);
            setDescription(model.description);
            setGroups(model.groups);
            setInterfaceType(model.interfaceType);
            setIpv6Addresses(model.ipv6Addresses);
            setMacAddress(model.macAddress);
            setNetworkInterfaceId(model.networkInterfaceId);
            setOwnerId(model.ownerId);
            setPrivateDnsName(model.privateDnsName);
            setPrivateIpAddress(model.privateIpAddress);
            setPrivateIpAddresses(model.privateIpAddresses);
            setRequesterId(model.requesterId);
            setRequesterManaged(model.requesterManaged);
            setSourceDestCheck(model.sourceDestCheck);
            setStatus(model.status);
            setSubnetId(model.subnetId);
            setTagSet(model.tagSet);
            setVpcId(model.vpcId);
        }

        public final NetworkInterfaceAssociation getAssociation() {
            return association;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation association) {
            this.association = association;
        }

        public final NetworkInterfaceAttachment getAttachment() {
            return attachment;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType.toString());
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public final void setInterfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType.toString());
        }

        public final Collection<NetworkInterfaceIpv6Address> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
        }

        @SafeVarargs
        public final void setIpv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<NetworkInterfacePrivateIpAddress> getPrivateIpAddresses() {
            return privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
        }

        @SafeVarargs
        public final void setPrivateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
        }

        public final String getRequesterId() {
            return requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final Boolean getRequesterManaged() {
            return requesterManaged;
        }

        @Override
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(NetworkInterfaceStatus status) {
            this.status(status.toString());
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<Tag> getTagSet() {
            return tagSet;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag... tagSet) {
            tagSet(Arrays.asList(tagSet));
            return this;
        }

        public final void setTagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
        }

        @SafeVarargs
        public final void setTagSet(Tag... tagSet) {
            tagSet(Arrays.asList(tagSet));
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }
    }
}
